/*
 * Decompiled with CFR 0.152.
 */
package paulscode.sound.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemLogger;
import paulscode.sound.utils.XMLNode;

public class XMLParser {
    private static SoundSystemLogger logger;

    public static XMLNode parseXML(URL xmlFile) {
        return new XMLNode(XMLParser.trimSpaces(XMLParser.readString(xmlFile)));
    }

    public static String getRawXML(URL xmlFile) {
        return XMLParser.trimSpaces(XMLParser.readString(xmlFile));
    }

    private static String readString(URL file) {
        InputStream in = null;
        try {
            in = file.openStream();
        }
        catch (IOException ioe) {
            XMLParser.errorMessage("Unable to open inputstream in method 'readString'");
            return null;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ByteArrayInputStream bin = null;
        BufferedReader bufRead = null;
        String fullString = "";
        byte[] buffer = new byte[4096];
        int read = 0;
        try {
            do {
                if ((read = in.read(buffer)) == -1) continue;
                bout.write(buffer, 0, read);
            } while (read != -1);
            bin = new ByteArrayInputStream(bout.toByteArray());
            bufRead = new BufferedReader(new InputStreamReader(bin));
            String line = "";
            do {
                if ((line = bufRead.readLine()) == null) continue;
                fullString = fullString + "\n" + line;
            } while (line != null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (bout != null) {
            try {
                bout.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (bin != null) {
            try {
                bin.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (bufRead != null) {
            try {
                bufRead.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        in = null;
        bout = null;
        bin = null;
        bufRead = null;
        return fullString;
    }

    public static String trimSpaces(String text) {
        String[] splitText = XMLParser.seperateWords(text);
        if (splitText == null || splitText.length == 0) {
            return "";
        }
        String parsedText = splitText[0];
        for (int x = 1; x < splitText.length; ++x) {
            parsedText = parsedText + " " + splitText[x];
        }
        return parsedText;
    }

    public static String[] seperateWords(String text) {
        if (text == null) {
            return null;
        }
        while (text.length() > 0 && text.substring(0, 1).matches("\\s")) {
            text = text.substring(1);
        }
        if (text.length() == 0) {
            return null;
        }
        String[] splitText = text.split("\\s+");
        return splitText;
    }

    protected static void errorMessage(String message) {
        if (logger == null) {
            logger = SoundSystemConfig.getLogger();
        }
        if (logger == null) {
            logger = new SoundSystemLogger();
            SoundSystemConfig.setLogger((SoundSystemLogger)logger);
        }
        logger.errorMessage("XMLParser", message, 0);
    }
}

