/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.ToolEvent;
import org.jhotdraw.draw.ToolListener;
import org.jhotdraw.draw.TransformEdit;
import org.jhotdraw.undo.CompositeEdit;

public abstract class AbstractTool
implements Tool {
    private boolean isActive;
    protected boolean isWorking;
    protected DrawingEditor editor;
    protected Point anchor = new Point();
    protected EventListenerList listenerList = new EventListenerList();

    public void addUndoableEditListener(UndoableEditListener l) {
        this.listenerList.add(UndoableEditListener.class, l);
    }

    public void removeUndoableEditListener(UndoableEditListener l) {
        this.listenerList.remove(UndoableEditListener.class, l);
    }

    public void activate(DrawingEditor editor) {
        this.editor = editor;
        this.isActive = true;
    }

    public void deactivate(DrawingEditor editor) {
        this.editor = editor;
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    protected DrawingView getView() {
        return this.editor.getView();
    }

    protected DrawingEditor getEditor() {
        return this.editor;
    }

    protected Drawing getDrawing() {
        return this.getView().getDrawing();
    }

    protected Point2D.Double viewToDrawing(Point p) {
        return this.constrainPoint(this.getView().viewToDrawing(p));
    }

    protected Point2D.Double constrainPoint(Point p) {
        return this.constrainPoint(this.getView().viewToDrawing(p));
    }

    protected Point2D.Double constrainPoint(Point2D.Double p) {
        return this.getView().getConstrainer().constrainPoint(p);
    }

    public void editDelete() {
        this.getView().getDrawing().removeAll(this.getView().getSelectedFigures());
    }

    public void editCut() {
    }

    public void editCopy() {
    }

    public void editDuplicate() {
    }

    public void editPaste() {
    }

    public void keyReleased(KeyEvent evt) {
        this.fireToolDone();
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void keyPressed(KeyEvent evt) {
        if (evt.getSource() instanceof Container) {
            this.editor.setView(this.editor.findView((Container)evt.getSource()));
        }
        switch (evt.getKeyCode()) {
            case 8: 
            case 127: {
                this.editDelete();
                break;
            }
            case 65: {
                if ((evt.getModifiers() & 6) == 0) break;
                this.getView().addToSelection(this.getView().getDrawing().getFigures());
                break;
            }
            case 37: {
                Collection<Figure> figures = this.getView().getSelectedFigures();
                AffineTransform tx = new AffineTransform();
                tx.translate(-1.0, 0.0);
                for (Figure f : figures) {
                    f.willChange();
                    f.basicTransform(tx);
                    f.changed();
                }
                this.getDrawing().fireUndoableEditHappened(new TransformEdit(figures, tx));
                break;
            }
            case 39: {
                Collection<Figure> figures = this.getView().getSelectedFigures();
                AffineTransform tx = new AffineTransform();
                tx.translate(1.0, 0.0);
                for (Figure f : figures) {
                    f.willChange();
                    f.basicTransform(tx);
                    f.changed();
                }
                this.getDrawing().fireUndoableEditHappened(new TransformEdit(figures, tx));
                break;
            }
            case 38: {
                Collection<Figure> figures = this.getView().getSelectedFigures();
                AffineTransform tx = new AffineTransform();
                tx.translate(0.0, -1.0);
                for (Figure f : figures) {
                    f.willChange();
                    f.basicTransform(tx);
                    f.changed();
                }
                this.getDrawing().fireUndoableEditHappened(new TransformEdit(figures, tx));
                break;
            }
            case 40: {
                Collection<Figure> figures = this.getView().getSelectedFigures();
                CompositeEdit edit = new CompositeEdit("Figur(en) verschieben");
                this.getDrawing().fireUndoableEditHappened(edit);
                AffineTransform tx = new AffineTransform();
                tx.translate(0.0, 1.0);
                for (Figure f : figures) {
                    f.willChange();
                    f.basicTransform(tx);
                    f.changed();
                }
                this.getDrawing().fireUndoableEditHappened(new TransformEdit(figures, tx));
                break;
            }
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
        if (!this.isWorking) {
            this.editor.setView(this.editor.findView((Container)evt.getSource()));
        }
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        DrawingView view = this.editor.findView((Container)evt.getSource());
        view.requestFocus();
        this.anchor = new Point(evt.getX(), evt.getY());
        this.isWorking = true;
        this.fireToolStarted(view);
    }

    public void mouseReleased(MouseEvent evt) {
        this.isWorking = false;
    }

    public void addToolListener(ToolListener l) {
        this.listenerList.add(ToolListener.class, l);
    }

    public void removeToolListener(ToolListener l) {
        this.listenerList.remove(ToolListener.class, l);
    }

    protected void fireToolStarted(DrawingView view) {
        ToolEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ToolListener.class) continue;
            if (event == null) {
                event = new ToolEvent(this, view, new Rectangle(0, 0, -1, -1));
            }
            ((ToolListener)listeners[i + 1]).toolStarted(event);
        }
    }

    protected void fireToolDone() {
        ToolEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ToolListener.class) continue;
            if (event == null) {
                event = new ToolEvent(this, this.getView(), new Rectangle(0, 0, -1, -1));
            }
            ((ToolListener)listeners[i + 1]).toolDone(event);
        }
    }

    protected void fireAreaInvalidated(Rectangle2D.Double r) {
        Point p1 = this.getView().drawingToView(new Point2D.Double(r.x, r.y));
        Point p2 = this.getView().drawingToView(new Point2D.Double(r.x + r.width, r.y + r.height));
        this.fireAreaInvalidated(new Rectangle(p1.x, p1.y, p2.x - p1.x, p2.y - p1.y));
    }

    protected void fireAreaInvalidated(Rectangle invalidatedArea) {
        ToolEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ToolListener.class) continue;
            if (event == null) {
                event = new ToolEvent(this, this.getView(), invalidatedArea);
            }
            ((ToolListener)listeners[i + 1]).areaInvalidated(event);
        }
    }

    public void draw(Graphics2D g) {
    }

    public void updateCursor(DrawingView view, Point p) {
        Handle handle = view.findHandle(p);
        if (handle != null) {
            view.setCursor(handle.getCursor());
        } else {
            Figure figure = view.findFigure(p);
            if (figure != null) {
                view.setCursor(figure.getCursor(view.viewToDrawing(p)));
            } else {
                view.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

