/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.BezierControlPointHandle;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.BezierNodeEdit;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.undo.CompositeEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BezierNodeHandle
extends AbstractHandle {
    protected int index;
    private CompositeEdit edit;
    private BezierPath.Node oldNode;

    public BezierNodeHandle(BezierFigure owner, int index) {
        super(owner);
        this.index = index;
    }

    @Override
    public void draw(Graphics2D g) {
        BezierFigure f = this.getBezierFigure();
        if (f.getPointCount() > this.index) {
            BezierPath.Node v = f.getNode(this.index);
            if (v.mask == 0) {
                this.drawRectangle(g, Color.black, Color.white);
            } else if (v.mask == 1 || v.mask == 2 || !f.isClosed() && v.mask == 3 && this.index == 0 || this.index == f.getNodeCount() - 1) {
                this.drawDiamond(g, Color.black, Color.white);
            } else {
                this.drawCircle(g, Color.black, Color.white);
            }
        }
    }

    protected BezierFigure getBezierFigure() {
        return (BezierFigure)this.getOwner();
    }

    protected Point getLocation() {
        return this.getBezierFigure().getPointCount() > this.index ? this.view.drawingToView(this.getBezierFigure().getPoint(this.index, 0)) : new Point(10, 10);
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle r = new Rectangle(this.getLocation());
        r.grow(this.getHandlesize() / 2, this.getHandlesize() / 2);
        return r;
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
        BezierFigure figure = this.getBezierFigure();
        this.edit = new CompositeEdit("Punkt verschieben");
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
        Point2D.Double location = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(this.getLocation()));
        Point2D.Double p = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(anchor));
        this.oldNode = figure.getNode(this.index);
        this.fireHandleRequestSecondaryHandles();
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        BezierFigure figure = this.getBezierFigure();
        figure.willChange();
        Point2D.Double p = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(lead));
        BezierPath.Node n = figure.getNode(this.index);
        this.fireAreaInvalidated(n);
        n.moveTo(p);
        this.fireAreaInvalidated(n);
        figure.basicSetNode(this.index, n);
        figure.changed();
    }

    private void fireAreaInvalidated(BezierPath.Node v) {
        Rectangle2D.Double dr = new Rectangle2D.Double(v.x[0], v.y[0], 0.0, 0.0);
        for (int i = 1; i < 3; ++i) {
            dr.add(v.x[i], v.y[i]);
        }
        Rectangle vr = this.view.drawingToView(dr);
        vr.grow(this.getHandlesize(), this.getHandlesize());
        this.fireAreaInvalidated(vr);
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        BezierFigure f = this.getBezierFigure();
        if ((modifiersEx & 0x180) != 0 && (modifiersEx & 0x800) == 0) {
            f.willChange();
            BezierPath.Node v = f.getNode(this.index);
            v.mask = this.index > 0 && this.index < f.getNodeCount() || f.isClosed() ? (v.mask + 3) % 4 : (this.index == 0 ? ((v.mask & 2) == 0 ? 2 : 0) : ((v.mask & 1) == 0 ? 1 : 0));
            f.basicSetNode(this.index, v);
            f.changed();
            this.fireHandleRequestSecondaryHandles();
        }
        this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(f, this.index, this.oldNode, f.getNode(this.index)));
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
    }

    @Override
    public boolean isCombinableWith(Handle h) {
        return false;
    }

    @Override
    public void trackDoubleClick(Point p, int modifiersEx) {
        BezierFigure f = this.getBezierFigure();
        if (f.getNodeCount() > 2 && (modifiersEx & 0x380) == 0) {
            Rectangle invalidatedArea = this.getDrawBounds();
            f.willChange();
            f.basicRemoveNode(this.index);
            f.changed();
            this.fireHandleRequestRemove(invalidatedArea);
        }
    }

    @Override
    public Collection<Handle> createSecondaryHandles() {
        int i;
        BezierFigure f = this.getBezierFigure();
        LinkedList<Handle> list = new LinkedList<Handle>();
        BezierPath.Node v = f.getNode(this.index);
        if ((v.mask & 1) != 0 && (this.index != 0 || f.isClosed())) {
            list.add(new BezierControlPointHandle(f, this.index, 1));
        }
        if ((v.mask & 2) != 0 && (this.index < f.getNodeCount() - 1 || f.isClosed())) {
            list.add(new BezierControlPointHandle(f, this.index, 2));
        }
        if (this.index > 0 || f.isClosed()) {
            i = this.index == 0 ? f.getNodeCount() - 1 : this.index - 1;
            v = f.getNode(i);
            if ((v.mask & 2) != 0) {
                list.add(new BezierControlPointHandle(f, i, 2));
            }
        }
        if (this.index < f.getNodeCount() - 2 || f.isClosed()) {
            i = this.index == f.getNodeCount() - 1 ? 0 : this.index + 1;
            v = f.getNode(i);
            if ((v.mask & 1) != 0) {
                list.add(new BezierControlPointHandle(f, i, 1));
            }
        }
        return list;
    }
}

