/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GeometryEdit;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.LocatorHandle;
import org.jhotdraw.draw.RelativeLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxHandleKit {
    public static void addLeadHandles(Figure f, Collection<Handle> handles) {
        handles.add(BoxHandleKit.southEast(f));
        handles.add(BoxHandleKit.southWest(f));
        handles.add(BoxHandleKit.northEast(f));
        handles.add(BoxHandleKit.northWest(f));
    }

    public static void addEdgeHandles(Figure f, Collection<Handle> handles) {
        handles.add(BoxHandleKit.south(f));
        handles.add(BoxHandleKit.north(f));
        handles.add(BoxHandleKit.east(f));
        handles.add(BoxHandleKit.west(f));
    }

    public static void addBoxHandles(Figure f, Collection<Handle> handles) {
        BoxHandleKit.addLeadHandles(f, handles);
        BoxHandleKit.addEdgeHandles(f, handles);
    }

    public static Handle south(Figure owner) {
        return new SouthHandle(owner);
    }

    public static Handle southEast(Figure owner) {
        return new SouthEastHandle(owner);
    }

    public static Handle southWest(Figure owner) {
        return new SouthWestHandle(owner);
    }

    public static Handle north(Figure owner) {
        return new NorthHandle(owner);
    }

    public static Handle northEast(Figure owner) {
        return new NorthEastHandle(owner);
    }

    public static Handle northWest(Figure owner) {
        return new NorthWestHandle(owner);
    }

    public static Handle east(Figure owner) {
        return new EastHandle(owner);
    }

    public static Handle west(Figure owner) {
        return new WestHandle(owner);
    }

    private static class WestHandle
    extends ResizeHandle {
        WestHandle(Figure owner) {
            super(owner, RelativeLocator.west());
        }

        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(Math.min(r.x + r.width - 1.0, p.x), r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(10);
        }
    }

    private static class SouthWestHandle
    extends ResizeHandle {
        SouthWestHandle(Figure owner) {
            super(owner, RelativeLocator.southWest());
        }

        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(Math.min(r.x + r.width - 1.0, p.x), r.y), new Point2D.Double(r.x + r.width, Math.max(r.y + 1.0, p.y)));
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(4);
        }
    }

    private static class SouthHandle
    extends ResizeHandle {
        SouthHandle(Figure owner) {
            super(owner, RelativeLocator.south());
        }

        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, Math.max(r.y + 1.0, p.y)));
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(9);
        }
    }

    private static class SouthEastHandle
    extends ResizeHandle {
        SouthEastHandle(Figure owner) {
            super(owner, RelativeLocator.southEast());
        }

        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(Math.max(r.x + 1.0, p.x), Math.max(r.y + 1.0, p.y)));
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(5);
        }
    }

    private static class NorthWestHandle
    extends ResizeHandle {
        NorthWestHandle(Figure owner) {
            super(owner, RelativeLocator.northWest());
        }

        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(Math.min(r.x + r.width - 1.0, p.x), Math.min(r.y + r.height - 1.0, p.y)), new Point2D.Double(r.x + r.width, r.y + r.height));
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(6);
        }
    }

    private static class NorthHandle
    extends ResizeHandle {
        NorthHandle(Figure owner) {
            super(owner, RelativeLocator.north());
        }

        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(r.x, Math.min(r.y + r.height - 1.0, p.y)), new Point2D.Double(r.x + r.width, r.y + r.height));
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(8);
        }
    }

    private static class EastHandle
    extends ResizeHandle {
        EastHandle(Figure owner) {
            super(owner, RelativeLocator.east());
        }

        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(Math.max(r.x + 1.0, p.x), r.y + r.height));
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(11);
        }
    }

    private static class NorthEastHandle
    extends ResizeHandle {
        NorthEastHandle(Figure owner) {
            super(owner, RelativeLocator.northEast());
        }

        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(r.x, Math.min(r.y + r.height - 1.0, p.y)), new Point2D.Double(Math.max(r.x, p.x), r.y + r.height));
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(7);
        }
    }

    private static class ResizeHandle
    extends LocatorHandle {
        private int dx;
        private int dy;
        Object geometry;

        ResizeHandle(Figure owner, Locator loc) {
            super(owner, loc);
        }

        public void trackStart(Point anchor, int modifiersEx) {
            this.geometry = this.getOwner().getRestoreData();
            Point location = this.getLocation();
            this.dx = -anchor.x + location.x;
            this.dy = -anchor.y + location.y;
        }

        public void trackStep(Point anchor, Point lead, int modifiersEx) {
            Point2D.Double p = this.view.viewToDrawing(new Point(lead.x + this.dx, lead.y + this.dy));
            this.view.getConstrainer().constrainPoint(p);
            this.trackStepNormalized(p);
        }

        public void trackEnd(Point anchor, Point lead, int modifiersEx) {
            this.fireUndoableEditHappened(new GeometryEdit(this.getOwner(), this.geometry, this.getOwner().getRestoreData()));
        }

        protected void trackStepNormalized(Point2D.Double p) {
        }

        protected void setBounds(Point2D.Double anchor, Point2D.Double lead) {
            Figure f = this.getOwner();
            f.willChange();
            Rectangle2D.Double oldBounds = f.getBounds();
            Rectangle2D.Double newBounds = new Rectangle2D.Double(Math.min(anchor.x, lead.x), Math.min(anchor.y, lead.y), Math.abs(anchor.x - lead.x), Math.abs(anchor.y - lead.y));
            double sx = newBounds.width / oldBounds.width;
            double sy = newBounds.height / oldBounds.height;
            AffineTransform tx = new AffineTransform();
            tx.translate(-oldBounds.x, -oldBounds.y);
            if (!(Double.isNaN(sx) || Double.isNaN(sy) || sx == 1.0 && sy == 1.0 || sx < 1.0E-4 || sy < 1.0E-4)) {
                f.basicTransform(tx);
                tx.setToIdentity();
                tx.scale(sx, sy);
                f.basicTransform(tx);
                tx.setToIdentity();
            }
            tx.translate(newBounds.x, newBounds.y);
            f.basicTransform(tx);
            f.changed();
        }
    }
}

