/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.LocatorHandle;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public class ConnectionHandle
extends LocatorHandle {
    private CompositeEdit edit;
    private ConnectionFigure currentConnection;
    private ConnectionFigure prototype;
    private Figure targetFigure;

    public ConnectionHandle(Figure owner, Locator locator, ConnectionFigure prototype) {
        super(owner, locator);
        this.prototype = prototype;
    }

    public void draw(Graphics2D g) {
        this.drawCircle(g, Color.blue, Color.blue.darker());
    }

    public void trackStart(Point anchor, int modifiersEx) {
        this.setConnection(this.createConnection());
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        this.edit = new CompositeEdit(labels.getString("createConnection"));
        this.fireUndoableEditHappened(this.edit);
        Point2D.Double p = this.getLocationOnDrawing();
        this.getConnection().setStartPoint(p);
        this.getConnection().setEndPoint(p);
        this.view.getDrawing().add(this.getConnection());
    }

    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        Connector target;
        Point2D.Double p = this.view.viewToDrawing(lead);
        Figure f = this.findConnectableFigure(p, this.view.getDrawing());
        if (f != this.getTargetFigure()) {
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().setConnectorsVisible(false, null);
            }
            this.setTargetFigure(f);
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().setConnectorsVisible(true, this.getConnection());
            }
        }
        if ((target = this.findConnectionTarget(p, this.view.getDrawing())) != null) {
            p = Geom.center(target.getBounds());
        }
        this.getConnection().setEndPoint(p);
    }

    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        Point2D.Double p = this.view.viewToDrawing(lead);
        Connector target = this.findConnectionTarget(p, this.view.getDrawing());
        if (target != null) {
            this.getConnection().setStartConnector(this.getStartConnector());
            this.getConnection().setEndConnector(target);
            this.getConnection().updateConnection();
        } else {
            this.view.getDrawing().remove(this.getConnection());
            this.edit.setSignificant(false);
        }
        this.setConnection(null);
        if (this.getTargetFigure() != null) {
            this.getTargetFigure().setConnectorsVisible(false, null);
            this.setTargetFigure(null);
        }
        this.fireUndoableEditHappened(this.edit);
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.prototype.clone();
    }

    protected void setConnection(ConnectionFigure newConnection) {
        this.currentConnection = newConnection;
    }

    protected ConnectionFigure getConnection() {
        return this.currentConnection;
    }

    protected Figure getTargetFigure() {
        return this.targetFigure;
    }

    protected void setTargetFigure(Figure newTargetFigure) {
        this.targetFigure = newTargetFigure;
    }

    private Figure findConnectableFigure(Point2D.Double p, Drawing drawing) {
        for (Figure figure : drawing.getFiguresFrontToBack()) {
            if (figure.includes(this.getConnection()) || !figure.canConnect() || !figure.contains(p)) continue;
            return figure;
        }
        return null;
    }

    protected Connector findConnectionTarget(Point2D.Double p, Drawing drawing) {
        Figure target = this.findConnectableFigure(p, drawing);
        if (target != null && target.canConnect() && !target.includes(this.getOwner()) && this.getConnection().canConnect(this.getOwner(), target)) {
            return target.findConnector(p, this.getConnection());
        }
        return null;
    }

    private Connector getStartConnector() {
        Point2D.Double p = this.getLocationOnDrawing();
        return this.getOwner().findConnector(p, this.getConnection());
    }
}

