/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Map;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.undo.CompositeEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionTool
extends AbstractTool
implements FigureListener {
    private Map<AttributeKey, Object> attributes;
    private Connector startConnector;
    private Connector endConnector;
    private Connector targetConnector;
    private Figure target;
    private ConnectionFigure connection;
    private int splitPoint;
    private ConnectionFigure editedConnection;
    private Figure createdFigure;
    protected ConnectionFigure prototype;
    protected boolean isPressed;

    public ConnectionTool(ConnectionFigure prototype) {
        this.prototype = prototype;
    }

    public ConnectionTool(ConnectionFigure prototype, Map attributes) {
        this.prototype = prototype;
        this.attributes = attributes;
    }

    public ConnectionTool(String prototypeClassName) {
        this(prototypeClassName, null);
    }

    public ConnectionTool(String prototypeClassName, Map<AttributeKey, Object> attributes) {
        try {
            this.prototype = (ConnectionFigure)Class.forName(prototypeClassName).newInstance();
        }
        catch (Exception e) {
            InternalError error = new InternalError("Unable to create ConnectionFigure from " + prototypeClassName);
            error.initCause(e);
            throw error;
        }
        this.attributes = attributes;
    }

    public ConnectionFigure getPrototype() {
        return this.prototype;
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.trackConnectors(evt);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        super.mousePressed(evt);
        this.isPressed = true;
        this.getView().clearSelection();
        Point2D.Double ap = this.viewToDrawing(this.anchor);
        if (this.getTargetFigure() != null) {
            this.getTargetFigure().setConnectorsVisible(false, null);
        }
        this.setTargetFigure(this.findConnectionStart(ap, this.getDrawing()));
        if (this.getTargetFigure() != null) {
            this.setStartConnector(this.findConnector(ap, this.target, this.prototype));
            if (this.getStartConnector() != null && this.canConnect(this.getTargetFigure())) {
                Point2D.Double p = this.getStartConnector().getAnchor();
                this.setConnection(this.createFigure());
                this.getConnection().basicSetBounds(p, p);
                this.getConnection().addFigureListener(this);
                this.setCreatedFigure(this.getConnection());
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point2D.Double p = this.viewToDrawing(new Point(e.getX(), e.getY()));
        if (this.getConnection() != null) {
            this.trackConnectors(e);
            if (this.getTargetConnector() != null) {
                p = this.getTargetConnector().getAnchor();
            }
            ConnectionFigure f = this.getConnection();
            this.fireAreaInvalidated(f.getDrawBounds());
            f.willChange();
            f.basicSetBounds(f.getStartPoint(), p);
            f.changed();
            this.fireAreaInvalidated(f.getDrawBounds());
        } else if (this.editedConnection != null) {
            this.editedConnection.willChange();
            this.editedConnection.setPoint(this.splitPoint, p);
            this.editedConnection.changed();
        }
    }

    protected boolean canConnect(Figure start) {
        return this.prototype.canConnect(start);
    }

    protected boolean canConnect(Figure start, Figure end) {
        return this.prototype.canConnect(start, end);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.isPressed = false;
        this.isWorking = false;
        Figure c = null;
        Point2D.Double p = this.viewToDrawing(new Point(e.getX(), e.getY()));
        if (this.getStartConnector() != null) {
            c = this.findTarget(p, this.getDrawing());
        }
        if (c != null) {
            this.setEndConnector(this.findConnector(p, c, this.prototype));
            if (this.getEndConnector() != null) {
                CompositeEdit creationEdit = new CompositeEdit("Verbindung erstellen");
                this.getDrawing().fireUndoableEditHappened(creationEdit);
                ConnectionFigure f = this.getConnection();
                f.willChange();
                f.setStartConnector(this.getStartConnector());
                f.setEndConnector(this.getEndConnector());
                f.basicSetBounds(f.getStartPoint(), p);
                f.updateConnection();
                f.changed();
                f.removeFigureListener(this);
                this.getDrawing().add(f);
                this.getDrawing().fireUndoableEditHappened(creationEdit);
            }
        } else if (this.getConnection() != null) {
            this.getDrawing().remove(this.getConnection());
        }
        this.setConnection(null);
        this.setStartConnector(null);
        this.setEndConnector(null);
        this.setCreatedFigure(null);
        this.fireToolDone();
    }

    @Override
    public void activate(DrawingEditor editor) {
        super.activate(editor);
    }

    @Override
    public void deactivate(DrawingEditor editor) {
        super.deactivate(editor);
        if (this.getTargetFigure() != null) {
            this.getTargetFigure().setConnectorsVisible(false, null);
        }
    }

    protected ConnectionFigure createFigure() {
        ConnectionFigure f = (ConnectionFigure)this.prototype.clone();
        this.getEditor().applyDefaultAttributesTo(f);
        if (this.attributes != null) {
            for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
                f.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return f;
    }

    protected Figure findSource(Point2D.Double p, Drawing drawing) {
        return this.findConnectableFigure(p, drawing);
    }

    protected Figure findTarget(Point2D.Double p, Drawing drawing) {
        Figure target = this.findConnectableFigure(p, drawing);
        Figure start = this.getStartConnector().getOwner();
        if (target != null && this.getConnection() != null && this.canConnect(target) && this.canConnect(start, target)) {
            return target;
        }
        return null;
    }

    protected ConnectionFigure findConnection(Point2D.Double p, Drawing drawing) {
        for (Figure f : drawing.getFiguresFrontToBack()) {
            if (f == null || !(f instanceof ConnectionFigure)) continue;
            return (ConnectionFigure)f;
        }
        return null;
    }

    protected void setConnection(ConnectionFigure newConnection) {
        this.connection = newConnection;
    }

    protected ConnectionFigure getConnection() {
        return this.connection;
    }

    protected void trackConnectors(MouseEvent e) {
        Point2D.Double p = this.viewToDrawing(new Point(e.getX(), e.getY()));
        Figure c = null;
        c = this.getStartConnector() == null ? this.findSource(p, this.getDrawing()) : this.findTarget(p, this.getDrawing());
        if (c != this.getTargetFigure()) {
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().setConnectorsVisible(false, null);
            }
            this.setTargetFigure(c);
            if (this.getStartConnector() != null) {
                if (this.getTargetFigure() != null && this.canConnect(this.getStartConnector().getOwner(), this.getTargetFigure())) {
                    this.getTargetFigure().setConnectorsVisible(true, this.getConnection());
                }
            } else if (this.getTargetFigure() != null && this.canConnect(this.getTargetFigure())) {
                this.getTargetFigure().setConnectorsVisible(true, this.getConnection());
            }
        }
        Connector cc = null;
        if (c != null) {
            cc = this.findConnector(p, c, this.prototype);
        }
        if (cc != this.getTargetConnector()) {
            this.setTargetConnector(cc);
        }
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.createdFigure != null) {
            Graphics2D gg = (Graphics2D)g.create();
            gg.transform(this.getView().getDrawingToViewTransform());
            this.createdFigure.draw(gg);
            gg.dispose();
        }
    }

    protected Connector findConnector(Point2D.Double p, Figure target, ConnectionFigure f) {
        return target.findConnector(p, f);
    }

    protected Figure findConnectionStart(Point2D.Double p, Drawing drawing) {
        Figure target = this.findConnectableFigure(p, drawing);
        if (target != null && target.canConnect()) {
            return target;
        }
        return null;
    }

    protected Figure findConnectableFigure(Point2D.Double p, Drawing drawing) {
        return drawing.findFigureExcept(p, this.createdFigure);
    }

    protected void setStartConnector(Connector newStartConnector) {
        this.startConnector = newStartConnector;
    }

    protected Connector getStartConnector() {
        return this.startConnector;
    }

    protected void setEndConnector(Connector newEndConnector) {
        this.endConnector = newEndConnector;
    }

    protected Connector getEndConnector() {
        return this.endConnector;
    }

    private void setTargetConnector(Connector newTargetConnector) {
        this.targetConnector = newTargetConnector;
    }

    protected Connector getTargetConnector() {
        return this.targetConnector;
    }

    private void setTargetFigure(Figure newTarget) {
        this.target = newTarget;
    }

    protected Figure getTargetFigure() {
        return this.target;
    }

    protected Figure getCreatedFigure() {
        return this.createdFigure;
    }

    protected void setCreatedFigure(Figure newCreatedFigure) {
        this.createdFigure = newCreatedFigure;
    }

    @Override
    public void figureAreaInvalidated(FigureEvent evt) {
        this.fireAreaInvalidated(evt.getInvalidatedArea());
    }

    @Override
    public void figureAdded(FigureEvent e) {
    }

    @Override
    public void figureChanged(FigureEvent e) {
    }

    @Override
    public void figureRemoved(FigureEvent e) {
    }

    @Override
    public void figureRequestRemove(FigureEvent e) {
    }

    @Override
    public void figureAttributeChanged(FigureEvent e) {
    }
}

