/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.AbstractDrawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureLayerComparator;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.util.ReversedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDrawing
extends AbstractDrawing
implements FigureListener,
UndoableEditListener {
    private ArrayList<Figure> figures = new ArrayList();
    private boolean needsSorting = false;

    @Override
    protected int indexOf(Figure figure) {
        return this.figures.indexOf(figure);
    }

    @Override
    public void basicAdd(int index, Figure figure) {
        this.figures.add(index, figure);
        figure.addFigureListener(this);
        figure.addUndoableEditListener(this);
        this.invalidateSortOrder();
    }

    @Override
    public void basicRemove(Figure figure) {
        this.figures.remove(figure);
        figure.removeFigureListener(this);
        figure.removeUndoableEditListener(this);
        this.invalidateSortOrder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics2D g) {
        Object object = this.getLock();
        synchronized (object) {
            this.ensureSorted();
            ArrayList<Figure> toDraw = new ArrayList<Figure>(this.figures.size());
            Rectangle clipRect = g.getClipBounds();
            for (Figure f : this.figures) {
                if (!f.getDrawBounds().intersects(clipRect)) continue;
                toDraw.add(f);
            }
            this.draw(g, toDraw);
        }
    }

    public void draw(Graphics2D g, Collection<Figure> figures) {
        for (Figure f : figures) {
            if (!f.isVisible()) continue;
            f.draw(g);
        }
    }

    @Override
    public Collection<Figure> sort(Collection<Figure> c) {
        HashSet<Figure> unsorted = new HashSet<Figure>();
        unsorted.addAll(c);
        ArrayList<Figure> sorted = new ArrayList<Figure>(c.size());
        for (Figure f : this.figures) {
            if (!unsorted.contains(f)) continue;
            sorted.add(f);
            unsorted.remove(f);
        }
        for (Figure f : c) {
            if (!unsorted.contains(f)) continue;
            sorted.add(f);
            unsorted.remove(f);
        }
        return sorted;
    }

    @Override
    public void figureAreaInvalidated(FigureEvent e) {
        this.fireAreaInvalidated(e.getInvalidatedArea());
    }

    @Override
    public void figureChanged(FigureEvent e) {
        this.invalidateSortOrder();
        this.fireAreaInvalidated(e.getInvalidatedArea());
    }

    @Override
    public void figureAdded(FigureEvent e) {
    }

    @Override
    public void figureRemoved(FigureEvent e) {
    }

    @Override
    public void figureRequestRemove(FigureEvent e) {
        this.remove(e.getFigure());
    }

    @Override
    public Figure findFigure(Point2D.Double p) {
        for (Figure f : this.getFiguresFrontToBack()) {
            if (!f.isVisible() || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Figure findFigureExcept(Point2D.Double p, Figure ignore) {
        for (Figure f : this.getFiguresFrontToBack()) {
            if (f == ignore || !f.isVisible() || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Figure findFigureExcept(Point2D.Double p, Collection<Figure> ignore) {
        for (Figure f : this.getFiguresFrontToBack()) {
            if (ignore.contains(f) || !f.isVisible() || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Collection<Figure> findFigures(Rectangle2D.Double bounds) {
        ArrayList<Figure> intersection = new ArrayList<Figure>();
        for (Figure f : this.figures) {
            if (!f.isVisible() || !f.getBounds().intersects(bounds)) continue;
            intersection.add(f);
        }
        return intersection;
    }

    @Override
    public Collection<Figure> findFiguresWithin(Rectangle2D.Double bounds) {
        ArrayList<Figure> contained = new ArrayList<Figure>();
        for (Figure f : this.figures) {
            if (!f.isVisible() || !bounds.contains(f.getBounds())) continue;
            contained.add(f);
        }
        return contained;
    }

    @Override
    public Collection<Figure> getFigures() {
        return Collections.unmodifiableCollection(this.figures);
    }

    @Override
    public Figure findFigureInside(Point2D.Double p) {
        Figure f = this.findFigure(p);
        return f == null ? null : f.findFigureInside(p);
    }

    @Override
    public List<Figure> getFiguresFrontToBack() {
        this.ensureSorted();
        return new ReversedList<Figure>(this.figures);
    }

    @Override
    public void bringToFront(Figure figure) {
        if (this.figures.remove(figure)) {
            this.figures.add(figure);
            this.invalidateSortOrder();
            this.fireAreaInvalidated(figure.getDrawBounds());
        }
    }

    @Override
    public void sendToBack(Figure figure) {
        if (this.figures.remove(figure)) {
            this.figures.add(0, figure);
            this.invalidateSortOrder();
            this.fireAreaInvalidated(figure.getDrawBounds());
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.fireUndoableEditHappened(e.getEdit());
    }

    @Override
    public void figureAttributeChanged(FigureEvent e) {
    }

    @Override
    public boolean contains(Figure f) {
        return this.figures.contains(f);
    }

    private void invalidateSortOrder() {
        this.needsSorting = true;
    }

    private void ensureSorted() {
        if (this.needsSorting) {
            Collections.sort(this.figures, FigureLayerComparator.INSTANCE);
            this.needsSorting = false;
        }
    }
}

