/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.BezierNodeHandle;
import org.jhotdraw.draw.ChangeConnectionEndHandle;
import org.jhotdraw.draw.ChangeConnectionStartHandle;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.LineFigure;
import org.jhotdraw.draw.Liner;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineConnectionFigure
extends LineFigure
implements ConnectionFigure {
    private Connector startConnector;
    private Connector endConnector;
    private Liner liner;
    private ConnectionHandler connectionHandler = new ConnectionHandler(this);

    @Override
    public void basicTransform(AffineTransform tx) {
        super.basicTransform(tx);
        this.updateConnection();
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        ArrayList<Handle> handles = new ArrayList<Handle>(this.getNodeCount());
        switch (detailLevel) {
            case 0: {
                if (this.getLiner() == null) {
                    int n = this.getNodeCount() - 1;
                    for (int i = 1; i < n; ++i) {
                        handles.add(new BezierNodeHandle(this, i));
                    }
                }
                handles.add(new ChangeConnectionStartHandle(this));
                handles.add(new ChangeConnectionEndHandle(this));
            }
        }
        return handles;
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public void updateConnection() {
        Point2D.Double end;
        Point2D.Double start;
        this.willChange();
        if (this.getStartConnector() != null && (start = this.getStartConnector().findStart(this)) != null) {
            this.basicSetStartPoint(start);
        }
        if (this.getEndConnector() != null && (end = this.getEndConnector().findEnd(this)) != null) {
            this.basicSetEndPoint(end);
        }
        this.changed();
    }

    @Override
    public void validate() {
        super.validate();
        this.lineout();
    }

    @Override
    public boolean canConnect(Figure start, Figure end) {
        return start.canConnect() && end.canConnect();
    }

    @Override
    public boolean connectsSame(ConnectionFigure other) {
        return other.getStartConnector() == this.getStartConnector() && other.getEndConnector() == this.getEndConnector();
    }

    @Override
    public Connector getEndConnector() {
        return this.endConnector;
    }

    @Override
    public Figure getEndFigure() {
        return this.endConnector == null ? null : this.endConnector.getOwner();
    }

    @Override
    public Connector getStartConnector() {
        return this.startConnector;
    }

    @Override
    public Figure getStartFigure() {
        return this.startConnector == null ? null : this.startConnector.getOwner();
    }

    @Override
    public final void setEndConnector(final Connector newEnd) {
        final Connector oldEnd = this.endConnector;
        if (newEnd != oldEnd) {
            this.willChange();
            this.basicSetEndConnector(newEnd);
            this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                public String getPresentationName() {
                    return "End-Verbindung setzen";
                }

                public void undo() throws CannotUndoException {
                    super.undo();
                    LineConnectionFigure.this.willChange();
                    LineConnectionFigure.this.basicSetEndConnector(oldEnd);
                    LineConnectionFigure.this.changed();
                }

                public void redo() throws CannotUndoException {
                    super.redo();
                    LineConnectionFigure.this.willChange();
                    LineConnectionFigure.this.basicSetEndConnector(newEnd);
                    LineConnectionFigure.this.changed();
                }
            });
            this.changed();
        }
    }

    protected void basicSetEndConnector(Connector newEnd) {
        if (newEnd != this.endConnector) {
            if (this.endConnector != null) {
                this.getEndFigure().removeFigureListener(this.connectionHandler);
                if (this.getStartFigure() != null) {
                    this.handleDisconnect(this.getStartFigure(), this.getEndFigure());
                }
            }
            this.endConnector = newEnd;
            if (this.endConnector != null) {
                this.getEndFigure().addFigureListener(this.connectionHandler);
                if (this.getStartFigure() != null && this.getEndFigure() != null) {
                    this.handleConnect(this.getStartFigure(), this.getEndFigure());
                    this.updateConnection();
                }
            }
        }
    }

    @Override
    public final void setStartConnector(final Connector newStart) {
        final Connector oldStart = this.startConnector;
        if (newStart != oldStart) {
            this.willChange();
            this.basicSetStartConnector(newStart);
            this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                public String getPresentationName() {
                    return "Start-Verbindung setzen";
                }

                public void undo() throws CannotUndoException {
                    super.undo();
                    LineConnectionFigure.this.willChange();
                    LineConnectionFigure.this.basicSetStartConnector(oldStart);
                    LineConnectionFigure.this.changed();
                }

                public void redo() throws CannotUndoException {
                    super.redo();
                    LineConnectionFigure.this.willChange();
                    LineConnectionFigure.this.basicSetStartConnector(newStart);
                    LineConnectionFigure.this.changed();
                }
            });
            this.changed();
        }
    }

    public void basicSetStartConnector(Connector newStart) {
        if (newStart != this.startConnector) {
            if (this.startConnector != null) {
                this.getStartFigure().removeFigureListener(this.connectionHandler);
                if (this.getEndFigure() != null) {
                    this.handleDisconnect(this.getStartFigure(), this.getEndFigure());
                }
            }
            this.startConnector = newStart;
            if (this.startConnector != null) {
                this.getStartFigure().addFigureListener(this.connectionHandler);
                if (this.getStartFigure() != null && this.getEndFigure() != null) {
                    this.handleConnect(this.getStartFigure(), this.getEndFigure());
                    this.updateConnection();
                }
            }
        }
    }

    @Override
    public void addNotify(Drawing drawing) {
        super.addNotify(drawing);
    }

    @Override
    public void removeNotify(Drawing drawing) {
        super.removeNotify(drawing);
    }

    protected void handleDisconnect(Figure start, Figure end) {
    }

    protected void handleConnect(Figure start, Figure end) {
    }

    @Override
    public LineConnectionFigure clone() {
        LineConnectionFigure that = (LineConnectionFigure)super.clone();
        that.connectionHandler = new ConnectionHandler(that);
        if (this.liner != null) {
            that.liner = this.liner.clone();
        }
        if (this.startConnector != null) {
            that.startConnector = (Connector)this.startConnector.clone();
            that.getStartFigure().addFigureListener(that.connectionHandler);
        }
        if (this.endConnector != null) {
            that.endConnector = (Connector)this.endConnector.clone();
            that.getEndFigure().addFigureListener(that.connectionHandler);
        }
        if (that.startConnector != null && that.endConnector != null) {
            that.handleConnect(that.getStartFigure(), that.getEndFigure());
            that.updateConnection();
        }
        return that;
    }

    @Override
    public void remap(Map oldToNew) {
        this.willChange();
        super.remap(oldToNew);
        Figure newStartFigure = null;
        Figure newEndFigure = null;
        if (this.getStartFigure() != null && (newStartFigure = (Figure)oldToNew.get(this.getStartFigure())) == null) {
            newStartFigure = this.getStartFigure();
        }
        if (this.getEndFigure() != null && (newEndFigure = (Figure)oldToNew.get(this.getEndFigure())) == null) {
            newEndFigure = this.getEndFigure();
        }
        if (newStartFigure != null) {
            this.setStartConnector(newStartFigure.findCompatibleConnector(this.getStartConnector(), true));
        }
        if (newEndFigure != null) {
            this.setEndConnector(newEndFigure.findCompatibleConnector(this.getEndConnector(), false));
        }
        this.updateConnection();
        this.changed();
    }

    @Override
    public boolean canConnect(Figure start) {
        return start.canConnect();
    }

    @Override
    public boolean handleMouseClick(Point2D.Double p, MouseEvent evt, DrawingView view) {
        if (this.getLiner() == null && evt.getClickCount() == 2) {
            this.willChange();
            final int index = this.basicSplitSegment(p, (float)(5.0 / view.getScaleFactor()));
            if (index != -1) {
                final BezierPath.Node newNode = this.getNode(index);
                this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                    public void redo() throws CannotRedoException {
                        super.redo();
                        LineConnectionFigure.this.willChange();
                        LineConnectionFigure.this.basicAddNode(index, newNode);
                        LineConnectionFigure.this.changed();
                    }

                    public void undo() throws CannotUndoException {
                        super.undo();
                        LineConnectionFigure.this.willChange();
                        LineConnectionFigure.this.basicRemoveNode(index);
                        LineConnectionFigure.this.changed();
                    }
                });
                this.changed();
                return true;
            }
        }
        return false;
    }

    @Override
    protected void readPoints(DOMInput in) throws IOException {
        super.readPoints(in);
        in.openElement("startConnector");
        this.setStartConnector((Connector)in.readObject());
        in.closeElement();
        in.openElement("endConnector");
        this.setEndConnector((Connector)in.readObject());
        in.closeElement();
    }

    @Override
    public void read(DOMInput in) throws IOException {
        this.readPoints(in);
        this.readAttributes(in);
        this.readLiner(in);
    }

    protected void readLiner(DOMInput in) throws IOException {
        if (in.getElementCount("liner") > 0) {
            in.openElement("liner");
            this.liner = (Liner)in.readObject();
            in.closeElement();
        }
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        this.writePoints(out);
        this.writeAttributes(out);
        this.writeLiner(out);
    }

    protected void writeLiner(DOMOutput out) throws IOException {
        if (this.liner != null) {
            out.openElement("liner");
            out.writeObject(this.liner);
            out.closeElement();
        }
    }

    @Override
    protected void writePoints(DOMOutput out) throws IOException {
        super.writePoints(out);
        out.openElement("startConnector");
        out.writeObject(this.getStartConnector());
        out.closeElement();
        out.openElement("endConnector");
        out.writeObject(this.getEndConnector());
        out.closeElement();
    }

    @Override
    public void setLiner(Liner newValue) {
        this.willChange();
        this.liner = newValue;
        this.changed();
    }

    @Override
    public void basicSetNode(int index, BezierPath.Node p) {
        if (index != 0 && index != this.getPointCount() - 1) {
            Point2D.Double end;
            Point2D.Double start;
            if (this.getStartConnector() != null && (start = this.getStartConnector().findStart(this)) != null) {
                this.basicSetStartPoint(start);
            }
            if (this.getEndConnector() != null && (end = this.getEndConnector().findEnd(this)) != null) {
                this.basicSetEndPoint(end);
            }
        }
        super.basicSetNode(index, p);
    }

    @Override
    public void lineout() {
        if (this.liner != null) {
            this.liner.lineout(this);
        }
    }

    @Override
    public BezierPath getBezierPath() {
        return this.path;
    }

    @Override
    public Liner getLiner() {
        return this.liner;
    }

    @Override
    public void setStartPoint(Point2D.Double p) {
        this.setPoint(0, p);
    }

    @Override
    public void setPoint(int index, Point2D.Double p) {
        this.setPoint(index, 0, p);
    }

    @Override
    public void setEndPoint(Point2D.Double p) {
        this.setPoint(this.getPointCount() - 1, p);
    }

    public void reverseConnection() {
        if (this.startConnector != null && this.endConnector != null) {
            this.handleDisconnect(this.startConnector.getOwner(), this.endConnector.getOwner());
            Connector tmpC = this.startConnector;
            this.startConnector = this.endConnector;
            this.endConnector = tmpC;
            Point2D.Double tmpP = this.getStartPoint();
            this.setStartPoint(this.getEndPoint());
            this.setEndPoint(tmpP);
            this.handleConnect(this.startConnector.getOwner(), this.endConnector.getOwner());
            this.updateConnection();
        }
    }

    private static class ConnectionHandler
    implements FigureListener {
        private LineConnectionFigure owner;

        private ConnectionHandler(LineConnectionFigure owner) {
            this.owner = owner;
        }

        public void figureRequestRemove(FigureEvent e) {
        }

        public void figureRemoved(FigureEvent evt) {
            this.owner.fireFigureRequestRemove();
        }

        public void figureChanged(FigureEvent e) {
            if (e.getSource() == this.owner.getStartFigure() || e.getSource() == this.owner.getEndFigure()) {
                this.owner.willChange();
                this.owner.updateConnection();
                this.owner.changed();
            }
        }

        public void figureAdded(FigureEvent e) {
        }

        public void figureAttributeChanged(FigureEvent e) {
        }

        public void figureAreaInvalidated(FigureEvent e) {
        }
    }
}

