/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.undo.CompositeEdit;

public class DefaultAttributeAction
extends AbstractSelectedAction {
    private AttributeKey[] keys;

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey key) {
        this(editor, key, null, null);
    }

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey[] keys) {
        this(editor, keys, null, null);
    }

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey key, Icon icon) {
        this(editor, key, null, icon);
    }

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey key, String name) {
        this(editor, key, name, null);
    }

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey key, String name, Icon icon) {
        this(editor, new AttributeKey[]{key}, name, icon);
    }

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey[] keys, String name, Icon icon) {
        super(editor);
        this.keys = keys;
        this.putValue("Name", name);
        this.putValue("SmallIcon", icon);
        this.setEnabled(true);
        editor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(DefaultAttributeAction.this.keys[0])) {
                    DefaultAttributeAction.this.putValue("attribute_" + DefaultAttributeAction.this.keys[0], evt.getNewValue());
                }
            }
        });
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.getView() != null && this.getView().getSelectionCount() > 0) {
            CompositeEdit edit = new CompositeEdit(this.labels.getString("drawAttributeChange"));
            this.fireUndoableEditHappened(edit);
            this.changeAttribute();
            this.fireUndoableEditHappened(edit);
        }
    }

    public void changeAttribute() {
        Drawing drawing = this.getDrawing();
        for (Figure figure : this.getView().getSelectedFigures()) {
            for (int j = 0; j < this.keys.length; ++j) {
                figure.setAttribute(this.keys[j], this.getEditor().getDefaultAttribute(this.keys[j]));
            }
        }
    }

    public void selectionChanged(FigureSelectionEvent evt) {
    }
}

