/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TransformEdit;
import org.jhotdraw.draw.action.AbstractSelectedAction;

public abstract class MoveAction
extends AbstractSelectedAction {
    private int dx;
    private int dy;

    public MoveAction(DrawingEditor editor, int dx, int dy) {
        super(editor);
        this.dx = dx;
        this.dy = dy;
    }

    public void actionPerformed(ActionEvent e) {
        AffineTransform tx = new AffineTransform();
        tx.translate(this.dx, this.dy);
        for (Figure f : this.getView().getSelectedFigures()) {
            f.willChange();
            f.basicTransform(tx);
            f.changed();
        }
        this.fireUndoableEditHappened(new TransformEdit(this.getView().getSelectedFigures(), tx));
    }

    public static class South
    extends MoveAction {
        public South(DrawingEditor editor) {
            super(editor, 0, 1);
            this.labels.configureAction(this, "moveSouth");
        }
    }

    public static class North
    extends MoveAction {
        public North(DrawingEditor editor) {
            super(editor, 0, -1);
            this.labels.configureAction(this, "moveNorth");
        }
    }

    public static class West
    extends MoveAction {
        public West(DrawingEditor editor) {
            super(editor, -1, 0);
            this.labels.configureAction(this, "moveWest");
        }
    }

    public static class East
    extends MoveAction {
        public East(DrawingEditor editor) {
            super(editor, 1, 0);
            this.labels.configureAction(this, "moveEast");
        }
    }
}

