/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.net;

import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.DefaultApplicationModel;
import org.jhotdraw.app.Project;
import org.jhotdraw.app.action.AbstractProjectAction;
import org.jhotdraw.app.action.Actions;
import org.jhotdraw.app.action.ExportAction;
import org.jhotdraw.app.action.ProjectPropertyAction;
import org.jhotdraw.app.action.ToggleProjectPropertyAction;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionTool;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.TextTool;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.action.ToolBarButtonFactory;
import org.jhotdraw.samples.net.NetProject;
import org.jhotdraw.samples.net.figures.NodeFigure;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetApplicationModel
extends DefaultApplicationModel {
    private static final double[] scaleFactors = new double[]{5.0, 4.0, 3.0, 2.0, 1.5, 1.25, 1.0, 0.75, 0.5, 0.25, 0.1};
    private DefaultDrawingEditor sharedEditor;
    private HashMap<String, Action> actions;

    @Override
    public void initApplication(Application a) {
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.net.Labels");
        this.putAction("export", new ExportAction(a));
        AbstractProjectAction aa = new ToggleProjectPropertyAction(a, "gridVisible");
        this.putAction("toggleGrid", aa);
        drawLabels.configureAction(aa, "alignGrid");
        for (double sf : scaleFactors) {
            aa = new ProjectPropertyAction(a, "scaleFactor", Double.TYPE, new Double(sf));
            this.putAction((int)(sf * 100.0) + "%", aa);
            aa.putValue("Name", (int)(sf * 100.0) + " %");
        }
    }

    public DefaultDrawingEditor getSharedEditor() {
        if (this.sharedEditor == null) {
            this.sharedEditor = new DefaultDrawingEditor();
        }
        return this.sharedEditor;
    }

    @Override
    public void initProject(Application a, Project p) {
        if (a.isSharingToolsAmongProjects()) {
            ((NetProject)p).setDrawingEditor(this.getSharedEditor());
        }
    }

    private void addCreationButtonsTo(JToolBar tb, DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.net.Labels");
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        ToolBarButtonFactory.addSelectionToolTo(tb, editor);
        tb.addSeparator();
        HashMap<AttributeKey<Color>, Color> attributes = new HashMap<AttributeKey<Color>, Color>();
        attributes.put(AttributeKeys.FILL_COLOR, Color.white);
        attributes.put(AttributeKeys.STROKE_COLOR, Color.black);
        attributes.put(AttributeKeys.TEXT_COLOR, Color.black);
        ToolBarButtonFactory.addToolTo(tb, editor, new TextTool((Figure)new NodeFigure(), attributes), "createNode", labels);
        attributes = new HashMap();
        attributes.put(AttributeKeys.STROKE_COLOR, new Color(153));
        ToolBarButtonFactory.addToolTo(tb, editor, new ConnectionTool(new LineConnectionFigure(), attributes), "createLink", labels);
    }

    @Override
    public List<JToolBar> createToolBars(Application a, Project pr) {
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.net.Labels");
        NetProject p = (NetProject)pr;
        DrawingEditor editor = p == null ? this.getSharedEditor() : p.getDrawingEditor();
        LinkedList<JToolBar> list = new LinkedList<JToolBar>();
        JToolBar tb = new JToolBar();
        this.addCreationButtonsTo(tb, editor);
        tb.setName(drawLabels.getString("drawToolBarTitle"));
        list.add(tb);
        tb = new JToolBar();
        ToolBarButtonFactory.addAttributesButtonsTo(tb, editor);
        tb.setName(drawLabels.getString("attributesToolBarTitle"));
        list.add(tb);
        tb = new JToolBar();
        ToolBarButtonFactory.addAlignmentButtonsTo(tb, editor);
        tb.setName(drawLabels.getString("alignmentToolBarTitle"));
        list.add(tb);
        return list;
    }

    @Override
    public List<JMenu> createMenus(Application a, Project pr) {
        NetProject p = (NetProject)pr;
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        LinkedList<JMenu> mb = new LinkedList<JMenu>();
        JMenu m = new JMenu();
        labels.configureMenu(m, "view");
        JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(this.getAction("toggleGrid"));
        Actions.configureJCheckBoxMenuItem(cbmi, this.getAction("toggleGrid"));
        m.add(cbmi);
        JMenu m2 = new JMenu("Zoom");
        for (double sf : scaleFactors) {
            String id = (int)(sf * 100.0) + "%";
            cbmi = new JCheckBoxMenuItem(this.getAction(id));
            Actions.configureJCheckBoxMenuItem(cbmi, this.getAction(id));
            m2.add(cbmi);
        }
        m.add(m2);
        mb.add(m);
        return mb;
    }

    private static class ToolButtonListener
    implements ItemListener {
        private Tool tool;
        private DrawingEditor editor;

        public ToolButtonListener(Tool t, DrawingEditor editor) {
            this.tool = t;
            this.editor = editor;
        }

        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() == 1) {
                this.editor.setTool(this.tool);
            }
        }
    }
}

