/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.net.figures;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AbstractConnector;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.ConnectionHandle;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.LocatorConnector;
import org.jhotdraw.draw.MoveHandle;
import org.jhotdraw.draw.RectangleFigure;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.Insets2DDouble;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeFigure
extends TextFigure {
    private LinkedList<AbstractConnector> connectors;
    private static LocatorConnector north;
    private static LocatorConnector south;
    private static LocatorConnector east;
    private static LocatorConnector west;

    public NodeFigure() {
        RectangleFigure rf = new RectangleFigure();
        this.setDecorator(rf);
        this.createConnectors();
        this.setDrawDecoratorFirst(true);
        AttributeKeys.DECORATOR_INSETS.set(this, new Insets2DDouble(6.0, 10.0, 6.0, 10.0));
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.net.Labels");
        this.setText(labels.getString("nodeDefaultName"));
    }

    private void createConnectors() {
        this.connectors = new LinkedList();
        this.connectors.add(new LocatorConnector(this, new RelativeLocator(0.5, 0.0)));
        this.connectors.add(new LocatorConnector(this, new RelativeLocator(0.5, 1.0)));
        this.connectors.add(new LocatorConnector(this, new RelativeLocator(1.0, 0.5)));
        this.connectors.add(new LocatorConnector(this, new RelativeLocator(0.0, 0.5)));
        for (AbstractConnector c : this.connectors) {
            c.setVisible(true);
        }
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
            handles.add(new MoveHandle(this, RelativeLocator.northWest()));
            handles.add(new MoveHandle(this, RelativeLocator.northEast()));
            handles.add(new MoveHandle(this, RelativeLocator.southWest()));
            handles.add(new MoveHandle(this, RelativeLocator.southEast()));
            handles.add(new ConnectionHandle(this, RelativeLocator.north(), new LineConnectionFigure()));
            handles.add(new ConnectionHandle(this, RelativeLocator.east(), new LineConnectionFigure()));
            handles.add(new ConnectionHandle(this, RelativeLocator.south(), new LineConnectionFigure()));
            handles.add(new ConnectionHandle(this, RelativeLocator.west(), new LineConnectionFigure()));
        }
        return handles;
    }

    @Override
    public Rectangle2D.Double getFigureDrawBounds() {
        Rectangle2D.Double b = super.getFigureDrawBounds();
        Geom.grow(b, 10.0, 10.0);
        return b;
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure figure) {
        double min = Double.MAX_VALUE;
        AbstractConnector closest = null;
        for (AbstractConnector c : this.connectors) {
            Point2D.Double p2 = Geom.center(c.getBounds());
            double d = Geom.length2(p.x, p.y, p2.x, p2.y);
            if (!(d < min)) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStart) {
        return this.connectors.getFirst();
    }

    @Override
    public NodeFigure clone() {
        NodeFigure that = (NodeFigure)super.clone();
        that.createConnectors();
        return that;
    }

    @Override
    protected void drawConnectors(Graphics2D g) {
        for (AbstractConnector c : this.connectors) {
            c.draw(g);
        }
    }

    @Override
    public int getLayer() {
        return -1;
    }

    @Override
    public void setAttribute(AttributeKey key, Object newValue) {
        super.setAttribute(key, newValue);
        if (this.getDecorator() != null) {
            this.getDecorator().setAttribute(key, newValue);
        }
    }
}

