/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss.loader;

import com.asual.lesscss.loader.ResourceLoader;
import java.io.IOException;

public class ChainedResourceLoader
implements ResourceLoader {
    private final ResourceLoader[] loaders;

    public ChainedResourceLoader(ResourceLoader ... loaders) {
        this.loaders = loaders;
    }

    @Override
    public boolean exists(String path) throws IOException {
        for (ResourceLoader loader : this.loaders) {
            if (!loader.exists(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String load(String path, String charset) throws IOException {
        for (ResourceLoader loader : this.loaders) {
            if (!loader.exists(path)) continue;
            return loader.load(path, charset);
        }
        throw new IOException("No such file " + path);
    }
}

