/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.LinuxPerfUtil;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.util.FileUtils;

public class LinuxPerfProfiler
extends LinuxPerfUtil
implements ExternalProfiler {
    private static final int DELAY_MSEC = Integer.getInteger("jmh.perf.delayMs", -1);

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        long delay = DELAY_MSEC == -1 ? TimeUnit.NANOSECONDS.toMillis((long)params.getWarmup().getCount() * params.getWarmup().getTime().convertTo(TimeUnit.NANOSECONDS)) + TimeUnit.SECONDS.toMillis(1L) : (long)DELAY_MSEC;
        if (IS_DELAYED) {
            return Arrays.asList("perf", "stat", "--log-fd", "2", "-d", "-d", "-d", "-D", String.valueOf(delay));
        }
        return Arrays.asList("perf", "stat", "--log-fd", "2", "-d", "-d", "-d");
    }

    @Override
    public Collection<String> addJVMOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    @Override
    public void beforeTrial(BenchmarkParams params) {
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkParams params, File stdOut, File stdErr) {
        PerfResult result = this.process(stdOut, stdErr);
        return Collections.singleton(result);
    }

    @Override
    public boolean allowPrintOut() {
        return true;
    }

    @Override
    public boolean allowPrintErr() {
        return false;
    }

    @Override
    public boolean checkSupport(List<String> msgs) {
        if (IS_SUPPORTED) {
            return true;
        }
        msgs.addAll(FAIL_MSGS);
        return false;
    }

    @Override
    public String label() {
        return "perf";
    }

    @Override
    public String getDescription() {
        return "Linux perf Statistics";
    }

    private PerfResult process(File stdOut, File stdErr) {
        PerfResult perfResult;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        FileReader fr = null;
        try {
            String line;
            fr = new FileReader(stdErr);
            BufferedReader reader = new BufferedReader(fr);
            long cycles = 0L;
            long insns = 0L;
            boolean printing = false;
            while ((line = reader.readLine()) != null) {
                Matcher m;
                if (printing) {
                    pw.println(line);
                }
                if (line.contains("Performance counter stats")) {
                    printing = true;
                }
                if (!(m = Pattern.compile("(.*)#(.*)").matcher(line)).matches()) continue;
                String pair = m.group(1).trim();
                if (pair.contains(" cycles")) {
                    try {
                        cycles = NumberFormat.getInstance().parse(pair.split("[ ]+")[0]).longValue();
                    }
                    catch (ParseException e) {
                        // empty catch block
                    }
                }
                if (!line.contains(" instructions")) continue;
                try {
                    insns = NumberFormat.getInstance().parse(pair.split("[ ]+")[0]).longValue();
                }
                catch (ParseException e) {}
            }
            if (!IS_DELAYED) {
                pw.println();
                pw.println("WARNING: Your system uses old \"perf\", which can not delay data collection.\nTherefore, perf performance data includes benchmark warmup.");
            }
            pw.flush();
            pw.close();
            perfResult = new PerfResult(sw.toString(), cycles, insns);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                FileUtils.safelyClose(fr);
                throw throwable;
            }
        }
        FileUtils.safelyClose(fr);
        return perfResult;
    }

    static class PerfResultAggregator
    implements Aggregator<PerfResult> {
        PerfResultAggregator() {
        }

        @Override
        public PerfResult aggregate(Collection<PerfResult> results) {
            long cycles = 0L;
            long instructions = 0L;
            String output = "";
            for (PerfResult r : results) {
                cycles += r.cycles;
                instructions += r.instructions;
                output = output + r.output;
            }
            return new PerfResult(output, cycles, instructions);
        }
    }

    static class PerfResult
    extends Result<PerfResult> {
        private static final long serialVersionUID = -1262685915873231436L;
        private final String output;
        private final long cycles;
        private final long instructions;

        public PerfResult(String output, long cycles, long instructions) {
            super(ResultRole.SECONDARY, "@cpi", PerfResult.of(1.0 * (double)cycles / (double)instructions), "CPI", AggregationPolicy.AVG);
            this.output = output;
            this.cycles = cycles;
            this.instructions = instructions;
        }

        @Override
        protected Aggregator<PerfResult> getThreadAggregator() {
            return new PerfResultAggregator();
        }

        @Override
        protected Aggregator<PerfResult> getIterationAggregator() {
            return new PerfResultAggregator();
        }

        @Override
        public String toString() {
            return String.format("%.3f cycles per instruction", 1.0 * (double)this.cycles / (double)this.instructions);
        }

        @Override
        public String extendedInfo(String label) {
            return "Perf stats:\n--------------------------------------------------\n" + this.output;
        }
    }
}

