/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.util.ListStatistics;
import org.openjdk.jmh.util.Statistics;

public abstract class Result<T extends Result<T>>
implements Serializable {
    private static final long serialVersionUID = -7332879501317733312L;
    protected final ResultRole role;
    protected final String label;
    protected final String unit;
    protected final Statistics statistics;
    protected final AggregationPolicy policy;

    public Result(ResultRole role, String label, Statistics s, String unit, AggregationPolicy policy) {
        this.role = role;
        this.label = label;
        this.unit = unit;
        this.statistics = s;
        this.policy = policy;
    }

    protected static Statistics of(double v) {
        ListStatistics s = new ListStatistics();
        s.addValue(v);
        return s;
    }

    public String getLabel() {
        return this.label;
    }

    public ResultRole getRole() {
        return this.role;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public final String getScoreUnit() {
        return this.unit;
    }

    public double getScore() {
        switch (this.policy) {
            case AVG: {
                return this.statistics.getMean();
            }
            case SUM: {
                return this.statistics.getSum();
            }
            case MAX: {
                return this.statistics.getMax();
            }
        }
        throw new IllegalStateException("Unknown aggregation policy: " + (Object)((Object)this.policy));
    }

    public double getScoreError() {
        switch (this.policy) {
            case AVG: {
                return this.statistics.getMeanErrorAt(0.999);
            }
            case SUM: 
            case MAX: {
                return Double.NaN;
            }
        }
        throw new IllegalStateException("Unknown aggregation policy: " + (Object)((Object)this.policy));
    }

    public double[] getScoreConfidence() {
        switch (this.policy) {
            case AVG: {
                return this.statistics.getConfidenceIntervalAt(0.999);
            }
            case SUM: 
            case MAX: {
                double score = this.getScore();
                return new double[]{score, score};
            }
        }
        throw new IllegalStateException("Unknown aggregation policy: " + (Object)((Object)this.policy));
    }

    public long getSampleCount() {
        return this.statistics.getN();
    }

    protected abstract Aggregator<T> getThreadAggregator();

    protected abstract Aggregator<T> getIterationAggregator();

    public String toString() {
        if (!Double.isNaN(this.getScoreError())) {
            return String.format("%.3f \u00b1(99.9%%) %.3f %s", this.getScore(), this.getScoreError(), this.getScoreUnit());
        }
        return String.format("%.3f %s", this.getScore(), this.getScoreUnit());
    }

    public String extendedInfo(String label) {
        return this.simpleExtendedInfo(label);
    }

    protected String simpleExtendedInfo(String label) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Statistics stats = this.getStatistics();
        if (stats.getN() > 2L) {
            double[] interval = this.getScoreConfidence();
            pw.println(String.format("Result%s: %.3f \u00b1(99.9%%) %.3f %s [%s]", new Object[]{label == null ? "" : " \"" + label + "\"", this.getScore(), (interval[1] - interval[0]) / 2.0, this.getScoreUnit(), this.policy}));
            pw.println(String.format("  Statistics: (min, avg, max) = (%.3f, %.3f, %.3f), stdev = %.3f%n  Confidence interval (99.9%%): [%.3f, %.3f]", stats.getMin(), stats.getMean(), stats.getMax(), stats.getStandardDeviation(), interval[0], interval[1]));
        } else {
            pw.println(String.format("Run result: %.2f %s (<= 2 samples)", stats.getMean(), this.getScoreUnit()));
        }
        pw.close();
        return sw.toString();
    }

    protected String percentileExtendedInfo(String label) {
        Statistics stats = this.getStatistics();
        StringBuilder sb = new StringBuilder();
        if (stats.getN() > 2L) {
            sb.append("  Samples, N = ").append(stats.getN()).append("\n");
            double[] interval = stats.getConfidenceIntervalAt(0.999);
            sb.append(String.format("        mean = %10.3f \u00b1(99.9%%) %.3f", stats.getMean(), (interval[1] - interval[0]) / 2.0));
            sb.append(" ").append(this.getScoreUnit()).append("\n");
            sb.append(String.format("         min = %10.3f %s\n", stats.getMin(), this.getScoreUnit()));
            for (double p : new double[]{0.0, 0.5, 0.9, 0.95, 0.99, 0.999, 0.9999, 0.99999, 0.999999}) {
                sb.append(String.format("  %9s = %10.3f %s\n", "p(" + String.format("%7.4f", p * 100.0) + ")", stats.getPercentile(p * 100.0), this.getScoreUnit()));
            }
            sb.append(String.format("         max = %10.3f %s\n", stats.getMax(), this.getScoreUnit()));
        }
        return sb.toString();
    }
}

