/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results.format;

import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.results.format.ResultFormat;
import org.openjdk.jmh.util.ClassUtils;

class LaTeXResultFormat
implements ResultFormat {
    private final PrintStream out;

    public LaTeXResultFormat(PrintStream out) {
        this.out = out;
    }

    @Override
    public void writeOut(Collection<RunResult> results) {
        TreeSet<String> params = new TreeSet<String>();
        HashSet<String> benchNames = new HashSet<String>();
        HashSet<String> units = new HashSet<String>();
        for (RunResult rr : results) {
            params.addAll(rr.getParams().getParamsKeys());
            units.add(rr.getPrimaryResult().getScoreUnit());
            benchNames.add(rr.getParams().getBenchmark());
            for (String label : rr.getSecondaryResults().keySet()) {
                benchNames.add(rr.getParams().getBenchmark() + ":" + label);
            }
        }
        boolean singleUnit = units.size() == 1;
        String unit = singleUnit ? (String)units.iterator().next() : null;
        Map<String, String> prefixes = ClassUtils.denseClassNames(benchNames);
        this.printHeader(params, singleUnit, unit);
        for (RunResult rr : results) {
            BenchmarkParams benchmarkParams = rr.getParams();
            Result res = rr.getPrimaryResult();
            this.printLine(benchmarkParams.getBenchmark(), benchmarkParams, params, prefixes, singleUnit, res);
            for (String label : rr.getSecondaryResults().keySet()) {
                Result subRes = rr.getSecondaryResults().get(label);
                this.printLine(benchmarkParams.getBenchmark() + ":" + label, benchmarkParams, params, prefixes, singleUnit, subRes);
            }
        }
        this.printFooter();
    }

    private void printHeader(SortedSet<String> params, boolean singleUnit, String unit) {
        this.out.print("\\begin{tabular}{r|");
        for (String p : params) {
            this.out.print("l|");
        }
        this.out.print("rl" + (singleUnit ? "" : "l") + "}\n");
        this.out.print(" \\multicolumn{1}{c|}{\\texttt{Benchmark}} & ");
        for (String p : params) {
            this.out.printf("\\texttt{%s}", p);
            this.out.print(" & ");
        }
        this.out.print(" \\multicolumn{" + (singleUnit ? 2 : 3) + "}{c}{\\texttt{Score" + (singleUnit ? ", " + unit : "") + "}} \\\\\n");
        this.out.print("\\hline\n");
    }

    private void printFooter() {
        this.out.print("\\end{tabular}");
    }

    private void printLine(String label, BenchmarkParams benchParams, SortedSet<String> params, Map<String, String> prefixes, boolean singleUnit, Result res) {
        this.out.printf("\\texttt{%s} & ", LaTeXResultFormat.escape(prefixes.get(label)));
        for (String p : params) {
            this.out.printf("\\texttt{%s}", LaTeXResultFormat.escape(benchParams.getParam(p)));
            this.out.print(" & ");
        }
        this.out.printf("\\texttt{%5.3f} & ", res.getScore());
        this.out.printf("\\scriptsize $\\pm$ \\texttt{%5.3f}", res.getScoreError());
        if (!singleUnit) {
            this.out.printf(" & \\texttt{%s}", res.getScoreUnit());
        }
        this.out.print(" \\\\");
        this.out.print("\n");
    }

    private static String escape(String s) {
        return s.replaceAll("_", "\\\\_");
    }
}

