/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results.format;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.results.format.ResultFormat;
import org.openjdk.jmh.util.ClassUtils;

class TextResultFormat
implements ResultFormat {
    private final PrintStream out;

    public TextResultFormat(PrintStream out) {
        this.out = out;
    }

    @Override
    public void writeOut(Collection<RunResult> runResults) {
        int COLUMN_PAD = 2;
        ArrayList<String> benchNames = new ArrayList<String>();
        for (RunResult runResult : runResults) {
            benchNames.add(runResult.getParams().getBenchmark());
            for (String label : runResult.getSecondaryResults().keySet()) {
                benchNames.add(runResult.getParams().getBenchmark() + ":" + label);
            }
        }
        Map<String, String> benchPrefixes = ClassUtils.denseClassNames(benchNames);
        int nameLen = "Benchmark".length();
        for (String prefix : benchPrefixes.values()) {
            nameLen = Math.max(nameLen, prefix.length());
        }
        HashMap<String, Integer> paramLengths = new HashMap<String, Integer>();
        TreeSet<String> params = new TreeSet<String>();
        for (RunResult runResult : runResults) {
            BenchmarkParams bp = runResult.getParams();
            for (String k : bp.getParamsKeys()) {
                params.add(k);
                Integer len = (Integer)paramLengths.get(k);
                if (len == null) {
                    len = ("(" + k + ")").length() + 2;
                }
                paramLengths.put(k, Math.max(len, bp.getParam(k).length() + 2));
            }
        }
        int modeLen = "Mode".length();
        int samplesLen = "Cnt".length();
        int scoreLen = "Score".length();
        int scoreErrLen = "Error".length();
        int unitLen = "Units".length();
        for (RunResult res : runResults) {
            Result primRes = res.getPrimaryResult();
            modeLen = Math.max(modeLen, res.getParams().getMode().shortLabel().length());
            samplesLen = Math.max(samplesLen, String.format("%d", primRes.getSampleCount()).length());
            scoreLen = Math.max(scoreLen, String.format("%.3f", primRes.getScore()).length());
            scoreErrLen = Math.max(scoreErrLen, String.format("%.3f", primRes.getScoreError()).length());
            unitLen = Math.max(unitLen, primRes.getScoreUnit().length());
            for (Result subRes : res.getSecondaryResults().values()) {
                samplesLen = Math.max(samplesLen, String.format("%d", subRes.getSampleCount()).length());
                scoreLen = Math.max(scoreLen, String.format("%.3f", subRes.getScore()).length());
                scoreErrLen = Math.max(scoreErrLen, String.format("%.3f", subRes.getScoreError()).length());
                unitLen = Math.max(unitLen, subRes.getScoreUnit().length());
            }
        }
        modeLen += 2;
        samplesLen += 2;
        scoreLen += 2;
        ++scoreErrLen;
        unitLen += 2;
        this.out.print(String.format("%-" + nameLen + "s", "Benchmark"));
        for (String k : params) {
            this.out.print(String.format("%" + paramLengths.get(k) + "s", "(" + k + ")"));
        }
        this.out.print(String.format("%" + modeLen + "s", "Mode"));
        this.out.print(String.format("%" + samplesLen + "s", "Cnt"));
        this.out.print(String.format("%" + scoreLen + "s", "Score"));
        this.out.print("  ");
        this.out.print(String.format("%" + scoreErrLen + "s", "Error"));
        this.out.print(String.format("%" + unitLen + "s", "Units"));
        this.out.println();
        for (RunResult res : runResults) {
            this.out.print(String.format("%-" + nameLen + "s", benchPrefixes.get(res.getParams().getBenchmark())));
            for (String string : params) {
                String v = res.getParams().getParam(string);
                this.out.print(String.format("%" + paramLengths.get(string) + "s", v == null ? "N/A" : v));
            }
            Result pRes = res.getPrimaryResult();
            this.out.print(String.format("%" + modeLen + "s", res.getParams().getMode().shortLabel()));
            this.out.print(String.format("%" + samplesLen + "d", pRes.getSampleCount()));
            this.out.print(String.format("%" + scoreLen + ".3f", pRes.getScore()));
            this.out.print(" \u00b1");
            this.out.print(String.format("%" + scoreErrLen + ".3f", pRes.getScoreError()));
            this.out.print(String.format("%" + unitLen + "s", pRes.getScoreUnit()));
            this.out.println();
            for (Map.Entry entry : res.getSecondaryResults().entrySet()) {
                String label = (String)entry.getKey();
                Result subRes = (Result)entry.getValue();
                this.out.print(String.format("%-" + nameLen + "s", benchPrefixes.get(res.getParams().getBenchmark() + ":" + label)));
                for (String k : params) {
                    String v = res.getParams().getParam(k);
                    this.out.print(String.format("%" + paramLengths.get(k) + "s", v == null ? "N/A" : v));
                }
                this.out.print(String.format("%" + modeLen + "s", res.getParams().getMode().shortLabel()));
                this.out.print(String.format("%" + samplesLen + "d", subRes.getSampleCount()));
                this.out.print(String.format("%" + scoreLen + ".3f", subRes.getScore()));
                this.out.print(" \u00b1");
                this.out.print(String.format("%" + scoreErrLen + ".3f", subRes.getScoreError()));
                this.out.print(String.format("%" + unitLen + "s", subRes.getScoreUnit()));
                this.out.println();
            }
        }
    }
}

