/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import org.openjdk.jmh.util.AbstractStatistics;
import org.openjdk.jmh.util.Multiset;
import org.openjdk.jmh.util.TreeMultiset;

public class MultisetStatistics
extends AbstractStatistics {
    private static final long serialVersionUID = -4401871054963903938L;
    private final Multiset<Double> values = new TreeMultiset<Double>();

    public void addValue(double d, long count) {
        this.values.add(d, count);
    }

    @Override
    public double getMax() {
        double max = Double.NEGATIVE_INFINITY;
        for (double d : this.values.keys()) {
            max = Math.max(max, d);
        }
        return max;
    }

    @Override
    public double getMin() {
        double min = Double.POSITIVE_INFINITY;
        for (double d : this.values.keys()) {
            min = Math.min(min, d);
        }
        return min;
    }

    @Override
    public long getN() {
        return this.values.size();
    }

    @Override
    public double getSum() {
        double sum = 0.0;
        for (double d : this.values.keys()) {
            sum += d * (double)this.values.count(d);
        }
        return sum;
    }

    private double get(long index) {
        long cur = 0L;
        for (double d : this.values.keys()) {
            if ((cur += this.values.count(d)) < index) continue;
            return d;
        }
        return this.getMax();
    }

    @Override
    public double getPercentile(double rank) {
        if (rank < 0.0 || rank > 100.0) {
            throw new IllegalArgumentException("Rank should be within [0; 100]");
        }
        if (rank == 0.0) {
            return this.getMin();
        }
        double pos = rank * (double)(this.values.size() + 1L) / 100.0;
        double floorPos = Math.floor(pos);
        double flooredValue = this.get((long)floorPos);
        double nextValue = this.get((long)floorPos + 1L);
        return flooredValue + (nextValue - flooredValue) * (pos - floorPos);
    }

    @Override
    public double getVariance() {
        if (this.getN() > 0L) {
            double v = 0.0;
            double m = this.getMean();
            for (double d : this.values.keys()) {
                v += Math.pow(d - m, 2.0) * (double)this.values.count(d);
            }
            return v / (double)(this.getN() - 1L);
        }
        return Double.NaN;
    }
}

