/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.openjdk.jmh.util.Multiset;

public class TreeMultiset<T extends Comparable<T>>
implements Multiset<T>,
Serializable {
    private static final long serialVersionUID = 3571810468402616517L;
    private final Map<T, Long> map = new TreeMap<T, Long>();
    private long size;

    @Override
    public void add(T element) {
        this.add(element, 1L);
    }

    @Override
    public void add(T element, long add) {
        Long count = this.map.get(element);
        if (count == null) {
            count = 0L;
        }
        count = count + add;
        this.size += add;
        if (count != 0L) {
            this.map.put(element, count);
        } else {
            this.map.remove(element);
        }
    }

    @Override
    public long count(T element) {
        Long count = this.map.get(element);
        return count == null ? 0L : count;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public Collection<T> keys() {
        return Collections.unmodifiableCollection(this.map.keySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeMultiset that = (TreeMultiset)o;
        if (this.size != that.size) {
            return false;
        }
        return this.map.equals(that.map);
    }

    public int hashCode() {
        int result = this.map.hashCode();
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        return result;
    }
}

