/*
 * Decompiled with CFR 0.152.
 */
package chaschev.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundedExecutorService
implements ExecutorService {
    private final ExecutorService executor;
    private final Semaphore semaphore;

    public BoundedExecutorService(ExecutorService executor, int bound) {
        this.executor = executor;
        this.semaphore = new Semaphore(bound);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public Future<?> submit(final Runnable command) throws RejectedExecutionException {
        try {
            this.semaphore.acquire();
            return this.executor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        command.run();
                    }
                    finally {
                        BoundedExecutorService.this.semaphore.release();
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.semaphore.release();
            throw e;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(final Callable<T> task) {
        try {
            this.semaphore.acquire();
            return this.executor.submit(new Callable<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T call() throws Exception {
                    try {
                        Object v = task.call();
                        return v;
                    }
                    finally {
                        BoundedExecutorService.this.semaphore.release();
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.semaphore.release();
            throw e;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void execute(Runnable command) {
        this.submit(command);
    }

    public ThreadFactory getThreadFactory() {
        if (this.executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.executor;
            return threadPoolExecutor.getThreadFactory();
        }
        throw new UnsupportedOperationException("todo implemented reflective call");
    }
}

