/*
 * Decompiled with CFR 0.152.
 */
package chaschev.io;

import java.lang.reflect.Constructor;

public class FBUtilities {
    private static final byte[] charToByte = new byte[256];
    static final char[] byteToChar = new char[16];
    private static final Constructor<String> stringConstructor;
    public static final int MAX_UNSIGNED_SHORT = 65535;

    public static String wrapCharArray(char[] c) {
        return FBUtilities.wrapCharArray(c, 0);
    }

    public static String wrapCharArray(char[] c, int offset) {
        return FBUtilities.wrapCharArray(c, offset, c.length);
    }

    public static String wrapCharArray(char[] c, int offset, int length) {
        if (c == null) {
            return null;
        }
        String s = null;
        if (stringConstructor != null) {
            try {
                s = stringConstructor.newInstance(offset, length, c);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return s == null ? new String(c) : s;
    }

    public static byte[] hexToBytes(String str) {
        if (str.length() % 2 == 1) {
            str = "0" + str;
        }
        byte[] bytes = new byte[str.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            byte halfByte1 = charToByte[str.charAt(i * 2)];
            byte halfByte2 = charToByte[str.charAt(i * 2 + 1)];
            if (halfByte1 == -1 || halfByte2 == -1) {
                throw new NumberFormatException("Non-hex characters in " + str);
            }
            bytes[i] = (byte)(halfByte1 << 4 | halfByte2);
        }
        return bytes;
    }

    public static String bytesToHex(byte ... bytes) {
        char[] c = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            byte bint = bytes[i];
            c[i * 2] = byteToChar[(bint & 0xF0) >> 4];
            c[1 + i * 2] = byteToChar[bint & 0xF];
        }
        return FBUtilities.wrapCharArray(c);
    }

    public static Constructor getProtectedConstructor(Class klass, Class ... paramTypes) {
        try {
            Constructor c = klass.getDeclaredConstructor(paramTypes);
            c.setAccessible(true);
            return c;
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        for (int c = 0; c < charToByte.length; c = (int)((char)(c + 1))) {
            FBUtilities.charToByte[c] = c >= 48 && c <= 57 ? (int)(c - 48) : (c >= 65 && c <= 70 ? (int)(c - 65 + 10) : (c >= 97 && c <= 102 ? (int)(c - 97 + 10) : -1));
        }
        for (int i = 0; i < 16; ++i) {
            FBUtilities.byteToChar[i] = Integer.toHexString(i).charAt(0);
        }
        stringConstructor = FBUtilities.getProtectedConstructor(String.class, Integer.TYPE, Integer.TYPE, char[].class);
    }
}

