/*
 * Decompiled with CFR 0.152.
 */
package chaschev.io;

import chaschev.io.ByteBufferUtils;
import chaschev.lang.LangUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    public static String LINE_SEPARATOR = "\n";

    public static ByteBuffer readFile(File file) throws Exception {
        return FileUtils.readFile(file, -1);
    }

    public static String readFileToString(File file) throws Exception {
        return ByteBufferUtils.string(FileUtils.readFile(file));
    }

    public static String readFileToString(File file, Charset charset) throws Exception {
        return ByteBufferUtils.string(FileUtils.readFile(file), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer readFile(File file, int limit) throws Exception {
        ByteBuffer byteBuffer;
        long length = Math.min(file.length(), limit == -1 ? Integer.MAX_VALUE : (long)limit);
        if (length == 0L) {
            return ByteBuffer.allocate(0);
        }
        ByteBuffer buf = ByteBuffer.allocateDirect((int)length);
        FileInputStream fis = null;
        FileChannel channel = null;
        try {
            fis = new FileInputStream(file);
            channel = fis.getChannel();
            int pos = 0;
            while (pos >= 0 && buf.remaining() > 0) {
                pos = channel.read(buf);
            }
            buf.rewind();
            byteBuffer = buf;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            IOUtils.closeQuietly(channel);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fis);
        IOUtils.closeQuietly((Closeable)channel);
        return byteBuffer;
    }

    public static byte[] toByteArray(InputStream inputStream, int limit, @Nullable ByteArrayOutputStream reusableStream) throws IOException {
        if (limit == -1) {
            limit = Integer.MAX_VALUE;
        }
        if (reusableStream == null) {
            reusableStream = new ByteArrayOutputStream(262144);
        }
        int chunkSize = 16384;
        byte[] buffer = new byte[16384];
        int lastRead = 0;
        int totalRead = 0;
        while (lastRead != -1 && totalRead < limit) {
            lastRead = limit - totalRead < 16384 ? inputStream.read(buffer, 0, limit - totalRead) : inputStream.read(buffer);
            if (lastRead <= 0) continue;
            reusableStream.write(buffer, 0, lastRead);
            totalRead += lastRead;
        }
        return reusableStream.toByteArray();
    }

    public static ByteCount humanReadableByteCount(double bytes) {
        return FileUtils.humanReadableByteCount(bytes, false);
    }

    public static ByteCount humanReadableByteCount(double bytes, boolean si) {
        return FileUtils.humanReadableByteCount(bytes, si, true);
    }

    public static ByteCount humanReadableByteCount(long bytes) {
        return FileUtils.humanReadableByteCount(bytes, false);
    }

    public static ByteCount humanReadableByteCount(double bytes, boolean si, boolean addByte) {
        return new ByteCount(bytes, si, addByte);
    }

    public static class ByteCount {
        final double bytes;
        final double count;
        final String unit;

        public ByteCount(double bytes, boolean si, boolean addByte) {
            int unitInt;
            this.bytes = bytes;
            int n = unitInt = si ? 1000 : 1024;
            if (bytes < (double)unitInt) {
                this.count = bytes;
                this.unit = addByte ? "B" : "";
                return;
            }
            int exp = (int)(Math.log(bytes) / Math.log(unitInt));
            char pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1);
            this.count = bytes / Math.pow(unitInt, exp);
            this.unit = pre + (addByte ? "B" : "");
        }

        public String toString(int fractionLength) {
            String s = LangUtils.toConciseString(this.count, fractionLength);
            return this.unit.isEmpty() ? s : s + this.unit;
        }

        public String toString() {
            return this.toString(1);
        }
    }
}

