/*
 * Decompiled with CFR 0.152.
 */
package chaschev.json;

import chaschev.json.Mapper;
import chaschev.util.Exceptions;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacksonMapper
implements Mapper {
    public static final TypeReference<Map<String, Object>> MAP_TYPE_REF = new TypeReference<Map<String, Object>>(){};
    public static final TypeReference<Map<String, String>> STRING_MAP_TYPE_REF = new TypeReference<Map<String, String>>(){};
    protected final ObjectMapper mapper = new ObjectMapper();
    protected ObjectWriter writer = this.mapper.writer();

    @Override
    public JacksonMapper prettyPrint(boolean b) {
        this.writer = b ? this.mapper.writerWithDefaultPrettyPrinter() : this.mapper.writer();
        return this;
    }

    @Override
    public String toJSON(Object obj) {
        try {
            return this.writer.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw Exceptions.runtime((Exception)((Object)e));
        }
    }

    @Override
    public <T> T fromJSON(String s, Class<T> aClass) {
        try {
            ObjectReader reader = this.mapper.reader(aClass);
            return (T)reader.readValue(s);
        }
        catch (IOException e) {
            throw Exceptions.runtime(e);
        }
    }

    @Override
    public Map<String, Object> toMap(String json) {
        try {
            return (Map)this.mapper.readValue(json, MAP_TYPE_REF);
        }
        catch (IOException e) {
            throw Exceptions.runtime(e);
        }
    }

    @Override
    public Map<String, String> toStringMap(String json) {
        try {
            return (Map)this.mapper.readValue(json, STRING_MAP_TYPE_REF);
        }
        catch (IOException e) {
            throw Exceptions.runtime(e);
        }
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }
}

