/*
 * Decompiled with CFR 0.152.
 */
package chaschev.lang;

import chaschev.lang.ObjectMethod;
import chaschev.lang.OpenBean;
import chaschev.lang.reflect.ClassDesc;
import chaschev.lang.reflect.ConstructorDesc;
import chaschev.lang.reflect.MethodDesc;
import chaschev.util.Exceptions;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Functions2 {
    public static <T> ObjectMethod<T> constructor(final Class<T> aClass, final Class ... params) {
        return new ObjectMethod<T>(){
            private final ConstructorDesc<T> constructor;
            {
                this.constructor = OpenBean.getClassDesc(aClass).getConstructorDesc(false, params);
            }

            @Override
            public T create(Object ... params2) {
                return this.constructor.newInstance(params2);
            }
        };
    }

    public static <T> ObjectMethod<T> method(Object obj, String method, Class ... params) {
        return Functions2.method(obj, method, false, params);
    }

    public static <T> ObjectMethod<T> method(final Object obj, final String method, final boolean strictly, final Class ... params) {
        return new ObjectMethod<T>(){
            private final MethodDesc methodDesc;
            {
                this.methodDesc = OpenBean.getClassDesc(obj.getClass()).getMethodDesc(method, strictly, params);
            }

            @Override
            public T create(Object ... params2) {
                return this.methodDesc.invoke(obj, params2);
            }
        };
    }

    public static <T> ObjectMethod<T> dynamicConstructor(final Class<T> aClass) {
        return new ObjectMethod<T>(){
            private final ClassDesc<T> classDesc;
            {
                this.classDesc = OpenBean.getClassDesc(aClass);
            }

            @Override
            public T create(Object ... params) {
                return this.classDesc.getConstructorDesc(false, params).newInstance(params);
            }
        };
    }

    public static <OBJECT, FIELD> Function<OBJECT, FIELD> field(final String fieldName) {
        final Field[] field = new Field[1];
        return new Function<OBJECT, FIELD>(){

            public FIELD apply(@Nullable OBJECT input) {
                if (input == null) {
                    return null;
                }
                Field _field = field[0];
                if (_field == null) {
                    _field = OpenBean.getClassDesc(input.getClass()).getField(fieldName);
                    Preconditions.checkNotNull((Object)_field, (Object)("no such field: " + fieldName));
                    field[0] = _field;
                }
                try {
                    return _field.get(input);
                }
                catch (Exception e) {
                    throw Exceptions.runtime(e);
                }
            }
        };
    }

    public static <OBJECT, RETURN> Function<OBJECT, RETURN> method(final String methodName) {
        final Method[] method = new Method[1];
        return new Function<OBJECT, RETURN>(){

            public RETURN apply(@Nullable OBJECT input) {
                if (input == null) {
                    return null;
                }
                Method _method = method[0];
                if (_method == null) {
                    MethodDesc methodDesc = OpenBean.getClassDesc(input.getClass()).getMethodDesc(methodName, true, new Class[0]);
                    Preconditions.checkNotNull((Object)methodDesc, (Object)("no such method: " + methodName));
                    _method = method[0] = methodDesc.getMethod();
                }
                try {
                    return _method.invoke(input, new Object[0]);
                }
                catch (Exception e) {
                    throw Exceptions.runtime(e);
                }
            }
        };
    }
}

