/*
 * Decompiled with CFR 0.152.
 */
package chaschev.lang;

import chaschev.lang.OpenBean;
import chaschev.util.Exceptions;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LangUtils {
    private static final DecimalFormat[] formats = new DecimalFormat[]{null, new DecimalFormat("#.#"), new DecimalFormat("#.##"), new DecimalFormat("#.###"), new DecimalFormat("#.####")};

    @Nonnull
    public static <T> T elvis(@Nullable T operand, @Nonnull T fallbackTo) {
        return operand == null ? fallbackTo : operand;
    }

    public static Unsafe getUnsafe() {
        try {
            Field singleoneInstanceField = Unsafe.class.getDeclaredField("theUnsafe");
            singleoneInstanceField.setAccessible(true);
            return (Unsafe)singleoneInstanceField.get(null);
        }
        catch (Exception e) {
            System.err.println("could not get unsafe!");
            e.printStackTrace(System.err);
            LoggerFactory.getLogger(OpenBean.class).error("could not get unsafe!", (Throwable)e);
            throw Exceptions.runtime(e);
        }
    }

    public static String toConciseString(double d, int fractionLength) {
        long asLong = (long)d;
        if (Math.abs(d - (double)asLong) < 1.0E-5) {
            return Long.toString(asLong);
        }
        return formats[fractionLength].format(d);
    }

    public static String millisToSec(long millis) {
        return LangUtils.toConciseString((double)millis / 1000.0, 1);
    }
}

