/*
 * Decompiled with CFR 0.152.
 */
package chaschev.lang;

import chaschev.lang.Functions2;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lists2 {
    public static <F, T> List<T> projectField(List<F> fromList, Class<F> elClass, Class<T> fieldClass, String name) {
        Function field = Functions2.field(name);
        return Lists.transform(fromList, field);
    }

    public static <F, T> List<T> projectMethod(List<F> fromList, Class<F> elClass, Class<T> methodClass, String name) {
        Function method = Functions2.method(name);
        return Lists.transform(fromList, method);
    }

    public static <F, T> List<T> projectField(List<F> fromList, String name) {
        Object nonNull = Iterables.find(fromList, (Predicate)Predicates.notNull(), null);
        if (nonNull == null) {
            if (fromList.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.nCopies(fromList.size(), null);
        }
        Class<?> aClass = nonNull.getClass();
        return Lists2.projectField(fromList, aClass, null, name);
    }

    public static <F, T> List<T> projectMethod(List<F> fromList, String name) {
        Object nonNull = Iterables.find(fromList, (Predicate)Predicates.notNull(), null);
        if (nonNull == null) {
            if (fromList.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.nCopies(fromList.size(), null);
        }
        Class<?> aClass = nonNull.getClass();
        return Lists2.projectMethod(fromList, aClass, null, name);
    }

    public static <T> List<T> removeDupsInSortedList(List<T> list) {
        int w = 0;
        int listSize = list.size();
        for (int r = 0; r < listSize; ++r) {
            if (r == 0) {
                ++w;
                continue;
            }
            if (list.get(r).equals(list.get(r - 1))) continue;
            list.set(w, list.get(r));
            ++w;
        }
        for (int last = list.size() - 1; last >= w; --last) {
            list.remove(last);
        }
        return list;
    }

    public static <T> List<T> newFilledArrayList(int size, T value) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            list.add(value);
        }
        return list;
    }

    public static <T> List<T> nInstances(int n, Supplier<T> supplier) {
        ArrayList list = Lists.newArrayListWithCapacity((int)n);
        for (int i = 0; i < n; ++i) {
            list.add(supplier.get());
        }
        return list;
    }

    public static <T> List<T> computingList(final int n, final Function<Integer, T> function) {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return function.apply((Object)index);
            }

            @Override
            public int size() {
                return n;
            }
        };
    }
}

