/*
 * Decompiled with CFR 0.152.
 */
package chaschev.lang;

import chaschev.lang.Lists2;
import chaschev.lang.reflect.ClassDesc;
import chaschev.lang.reflect.ConstructorDesc;
import chaschev.lang.reflect.MethodDesc;
import chaschev.lang.reflect.NoSuchMethodException;
import chaschev.util.Exceptions;
import com.google.common.base.Optional;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.FluentIterable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenBean {
    private static final CustomCopyHandler DEFAULT_HANDLER = new CustomCopyHandler(){

        public final boolean handle(Field field1, Field field2, Object dest, Object src, String name) throws Exception {
            field1.set(dest, field2.get(src));
            return true;
        }

        public boolean handle(Field destField, Object dest, Object srcValue, String name) throws Exception {
            Class<?> destClass = destField.getType();
            if (destClass.isEnum() && srcValue instanceof String) {
                srcValue = Enum.valueOf(destClass, (String)srcValue);
            }
            try {
                destField.set(dest, srcValue);
            }
            catch (Exception e) {
                throw Exceptions.runtime(e);
            }
            return true;
        }
    };

    public static Map<String, Object> putAll(Map<String, Object> dest, Object src) {
        try {
            for (Field field : OpenBean.getClassDesc(src.getClass()).fields) {
                Object v = field.get(src);
                dest.put(field.getName(), v);
            }
            return dest;
        }
        catch (IllegalAccessException e) {
            throw Exceptions.runtime(e);
        }
    }

    public static Object putAll(Object dest, Map<String, Object> src) {
        try {
            for (Field field : OpenBean.getClassDesc(dest.getClass()).fields) {
                String name = field.getName();
                if (!src.containsKey(name)) continue;
                Object v = src.get(name);
                field.set(dest, v);
            }
            return dest;
        }
        catch (IllegalAccessException e) {
            throw Exceptions.runtime(e);
        }
    }

    public static <T> ClassDesc<T> getClassDesc(Class<T> aClass) {
        return ClassDesc.getClassDesc(aClass);
    }

    public static <T> Optional<T> getFieldValue(Object object, String fieldName, Class<T> tClass) {
        try {
            Field field = OpenBean._getField(object, fieldName);
            if (field == null) {
                return Optional.absent();
            }
            return Optional.of((Object)field.get(object));
        }
        catch (IllegalAccessException e) {
            throw Exceptions.runtime(e);
        }
    }

    public static Object getFieldValue(Object object, String fieldName) {
        try {
            return OpenBean._getField(object, fieldName).get(object);
        }
        catch (IllegalAccessException e) {
            throw Exceptions.runtime(e);
        }
    }

    public static Object getOrInitCollection(Object object, String fieldName) {
        try {
            Field collectionField = OpenBean._getField(object, fieldName);
            Class<?> aClass = collectionField.getType();
            Cloneable value = collectionField.get(object);
            if (value == null) {
                if (List.class.isAssignableFrom(aClass)) {
                    value = new ArrayList();
                } else if (Set.class.isAssignableFrom(aClass)) {
                    value = new HashSet();
                } else if (Map.class.isAssignableFrom(aClass)) {
                    value = new HashMap();
                } else {
                    throw new IllegalStateException("could not init collection/map for field: " + fieldName + " of class " + object.getClass());
                }
                collectionField.set(object, value);
            }
            return value;
        }
        catch (IllegalAccessException e) {
            throw Exceptions.runtime(e);
        }
    }

    public static Optional<Field> getField(Object object, String fieldName) {
        return Optional.fromNullable((Object)OpenBean._getField(object, fieldName));
    }

    private static Field _getField(Object object, String fieldName) {
        return OpenBean.getClassDesc(object.getClass()).getField(fieldName);
    }

    public static Optional<MethodDesc> getMethod(Object object, String methodName, Object ... params) {
        MethodDesc methodDesc = OpenBean.getClassDesc(object.getClass()).getMethodDesc(methodName, false, params);
        return Optional.fromNullable((Object)methodDesc);
    }

    public static void setField(Object object, String fieldName, Object value) {
        try {
            OpenBean._getField(object, fieldName).set(object, value);
        }
        catch (IllegalAccessException e) {
            throw Exceptions.runtime(e);
        }
    }

    public static void copyFields(Object dest, Object src) {
        OpenBean.copyFields(dest, src, DEFAULT_HANDLER);
    }

    public static void copyFields(Object dest, Map src) {
        OpenBean.copyFields(dest, src, DEFAULT_HANDLER);
    }

    public static void copyFields(Object dest, Map<String, ?> src, CustomCopyHandler handler) {
        ClassDesc<?> destClassDesc = OpenBean.getClassDesc(dest.getClass());
        try {
            for (Map.Entry<String, ?> entry : src.entrySet()) {
                String name = entry.getKey();
                Field destField = destClassDesc.getField(name);
                if (destField == null) continue;
                Object srcValue = entry.getValue();
                if (handler != null && handler.handle(destField, dest, srcValue, name)) continue;
                DEFAULT_HANDLER.handle(destField, dest, srcValue, name);
            }
        }
        catch (Exception e) {
            throw Exceptions.runtime(e);
        }
    }

    public static void copyFields(Object dest, Object src, CustomCopyHandler handler) {
        ClassDesc<?> destClassDesc = OpenBean.getClassDesc(dest.getClass());
        ClassDesc<?> srcClassDesc = OpenBean.getClassDesc(src.getClass());
        int i1 = 0;
        int i2 = 0;
        int l1 = destClassDesc.fields.length;
        int l2 = srcClassDesc.fields.length;
        try {
            while (true) {
                String name2;
                Field field1 = destClassDesc.fields[i1];
                Field field2 = srcClassDesc.fields[i2];
                String name1 = field1.getName();
                int r = name1.compareTo(name2 = field2.getName());
                if (r == 0) {
                    if (handler == null || !handler.handle(field1, field2, dest, src, name1)) {
                        DEFAULT_HANDLER.handle(field1, field2, dest, src, name1);
                    }
                    if (++i1 < l1 && ++i2 < l2) continue;
                    break;
                }
                if (r < 0 ? ++i1 >= l1 : ++i2 >= l2) break;
            }
        }
        catch (Exception e) {
            throw Exceptions.runtime(e);
        }
    }

    private static boolean isClass(Object object) {
        return object instanceof Class;
    }

    public static Object getStaticFieldValue(Class aClass, String name) {
        try {
            Field field = OpenBean.getClassDesc(aClass).getStaticField(name);
            if (field == null) {
                throw new RuntimeException("no such field '" + name + "' " + " in class " + aClass);
            }
            return field.get(aClass);
        }
        catch (IllegalAccessException e) {
            throw Exceptions.runtime(e);
        }
    }

    public static Object invokeStatic(Class aClass, String name, Object ... args) {
        try {
            MethodDesc method = OpenBean.getClassDesc(aClass).getStaticMethodDesc(name, false, new Object[0]);
            if (method == null) {
                throw new RuntimeException("no such method '" + name + "' " + " in class " + aClass);
            }
            return method.invoke(aClass, args);
        }
        catch (Exception e) {
            throw Exceptions.runtime(e);
        }
    }

    public static Object invoke(Object object, String name, Object ... args) {
        try {
            MethodDesc method = OpenBean.getClassDesc(object.getClass()).getMethodDesc(name, false, args);
            if (method == null) {
                throw new RuntimeException("no such method '" + name + "' " + " in object " + object.getClass());
            }
            return method.invoke(object, args);
        }
        catch (Exception e) {
            throw Exceptions.runtime(e);
        }
    }

    public static Object newByClass(String className, Object ... params) {
        return OpenBean.newByClass(className, false, params);
    }

    public static Object newByClassStrict(String className, Object ... params) {
        return OpenBean.newByClass(className, true, params);
    }

    private static Object newByClass(String className, boolean strictly, Object ... params) {
        try {
            return OpenBean.newInstance(Class.forName(className), strictly, params);
        }
        catch (ClassNotFoundException e) {
            throw Exceptions.runtime(e);
        }
    }

    public static <T> T newInstance(Class<? extends T> aClass, Object ... params) {
        return OpenBean.newInstance(aClass, false, params);
    }

    public static <T> T newInstanceStrict(Class<T> aClass, Object ... params) {
        return OpenBean.newInstance(aClass, true, params);
    }

    private static <T> T newInstance(Class<T> aClass, boolean strictly, Object ... params) {
        ConstructorDesc<T> desc = OpenBean.getConstructorDesc(aClass, strictly, params);
        if (desc == null) {
            throw new NoSuchMethodException("constructor not found, class = " + aClass.getSimpleName() + ", strict = " + strictly + ", params = " + Arrays.asList(params));
        }
        return desc.newInstance(params);
    }

    public static <T> ConstructorDesc<T> getConstructorDesc(Class<T> aClass, Object ... params) {
        return OpenBean.getConstructorDesc(aClass, false, params);
    }

    public static <T> ConstructorDesc<T> getConstructorDescStrict(Class<T> aClass, Object ... params) {
        return OpenBean.getConstructorDesc(aClass, true, params);
    }

    private static <T> ConstructorDesc<T> getConstructorDesc(Class<T> aClass, boolean strictly, Object ... params) {
        return OpenBean.getClassDesc(aClass).getConstructorDesc(strictly, params);
    }

    public static <T> ConstructorDesc<T> getConstructorDesc(Class<T> aClass, Class ... classes) {
        return OpenBean.getConstructorDesc(aClass, false, classes);
    }

    public static <T> ConstructorDesc<T> getConstructorDescStrict(Class<T> aClass, Class ... classes) {
        return OpenBean.getConstructorDesc(aClass, true, classes);
    }

    private static <T> ConstructorDesc<T> getConstructorDesc(Class<T> aClass, boolean strictly, Class ... classes) {
        return OpenBean.getClassDesc(aClass).getConstructorDesc(strictly, classes);
    }

    public static Iterable<Field> fieldsOfType(Object obj, Class<?> aClass) {
        return OpenBean.fieldsOfType(obj, aClass, false);
    }

    public static Iterable<Field> fieldsOfType(Object obj, Class<?> aClass, boolean strict) {
        return OpenBean.fieldsOfType(obj.getClass(), aClass, strict);
    }

    public static Iterable<Field> fieldsOfType(Class<?> objClass, Class<?> fieldClass) {
        return OpenBean.fieldsOfType(objClass, fieldClass, false);
    }

    public static <T> List<MethodDesc<? extends T>> methodsReturning(Object obj, Class<? extends T> returnClass) {
        return OpenBean.methodsReturning(obj.getClass(), returnClass);
    }

    public static <T> List<MethodDesc<? extends T>> methodsReturning(Class<?> objClass, Class<? extends T> returnClass) {
        return OpenBean.methodsReturning(objClass, returnClass, false);
    }

    public static <T> List<MethodDesc<? extends T>> methodsReturning(Class<?> objClass, Class<? extends T> returnClass, boolean strict) {
        ArrayList<MethodDesc<T>> result = new ArrayList<MethodDesc<T>>(4);
        for (MethodDesc method : OpenBean.getClassDesc(objClass).methods) {
            Class<?> actualReturnType = method.getMethod().getReturnType();
            if (!strict) {
                if (!returnClass.isAssignableFrom(actualReturnType)) continue;
                result.add(method);
                continue;
            }
            if (returnClass != actualReturnType) continue;
            result.add(method);
        }
        return result;
    }

    public static Iterable<Field> fieldsOfType(Class<?> objClass, final Class<?> fieldClass, final boolean strict) {
        final Field[] fields = OpenBean.getClassDesc(objClass).fields;
        return new FluentIterable<Field>(){

            public Iterator<Field> iterator() {
                return new AbstractIterator<Field>(){
                    int i = 0;
                    final int l;
                    {
                        this.l = fields.length;
                    }

                    protected Field computeNext() {
                        while (this.i < this.l) {
                            Field field = fields[this.i++];
                            if (!(strict ? field.getType() == fieldClass : fieldClass.isAssignableFrom(field.getType()))) continue;
                            return field;
                        }
                        return (Field)this.endOfData();
                    }
                };
            }
        };
    }

    public static List<String> fieldNames(Class<?> aClass) {
        return Lists2.projectMethod(OpenBean.fields(aClass), Field.class, String.class, "getName");
    }

    public static List<Field> fields(Class<?> aClass) {
        return Arrays.asList(OpenBean.getClassDesc(aClass).fields);
    }

    public static List<String> methodNames(Class<?> aClass) {
        return Lists2.projectMethod(OpenBean.methods(aClass), MethodDesc.class, String.class, "getName");
    }

    public static List<MethodDesc> methods(Class<?> aClass) {
        return Arrays.asList(OpenBean.getClassDesc(aClass).methods);
    }

    public static abstract class CustomCopyHandler {
        public boolean handle(Field field1, Field field2, Object dest, Object src, String name) throws Exception {
            return this.handle(field1, field2.get(dest), src, name);
        }

        public boolean handle(Field destField, Object srcValue, Object dest, String name) throws Exception {
            throw new UnsupportedOperationException("todo");
        }
    }
}

