/*
 * Decompiled with CFR 0.152.
 */
package chaschev.lang;

import chaschev.lang.OpenBean;
import chaschev.lang.reflect.MethodDesc;
import chaschev.util.Exceptions;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Predicates2 {
    public static Predicate<String> contains(final CharSequence cs) {
        return new Predicate<String>(){

            public boolean apply(String input) {
                return input.contains(cs);
            }
        };
    }

    public static <T> Predicate<T> functionAppliedEquals(final Function<T, ?> fun, final Object to) {
        return new Predicate<T>(){

            public boolean apply(@Nullable T input) {
                Object r = fun.apply(input);
                return Predicates2.objectsEqual(r, to);
            }
        };
    }

    public static <T> Predicate<T> functionAppliedNotEqual(final Function<T, ?> fun, final Object to) {
        return new Predicate<T>(){

            public boolean apply(@Nullable T input) {
                Object r = fun.apply(input);
                return !Predicates2.objectsEqual(r, to);
            }
        };
    }

    public static <T> Predicate<T> methodEquals(String method, Object to) {
        return Predicates2.methodEquals(to, method, new Object[0]);
    }

    public static <T> Predicate<T> methodEquals(final Object to, final String method, final Object ... params) {
        final MethodDesc[] desc = new MethodDesc[1];
        return new Predicate<T>(){

            public boolean apply(@Nullable T input) {
                if (input == null) {
                    return false;
                }
                if (desc[0] == null) {
                    desc[0] = OpenBean.getClassDesc(input.getClass()).getMethodDesc(method, false, params);
                    if (desc[0] == null) {
                        throw new IllegalArgumentException("no such method: " + method);
                    }
                }
                Object r = desc[0].invoke(input, params);
                return Predicates2.objectsEqual(r, to);
            }
        };
    }

    public static <T> Predicate<T> fieldEquals(final String field, final Object to) {
        final Field[] desc = new Field[1];
        return new Predicate<T>(){

            public boolean apply(@Nullable T input) {
                if (input == null) {
                    return false;
                }
                if (desc[0] == null) {
                    desc[0] = OpenBean.getClassDesc(input.getClass()).getField(field);
                    if (desc[0] == null) {
                        throw new IllegalArgumentException("no such field: " + field);
                    }
                }
                Object r = null;
                try {
                    r = desc[0].get(input);
                }
                catch (IllegalAccessException e) {
                    throw Exceptions.runtime(e);
                }
                return Predicates2.objectsEqual(r, to);
            }
        };
    }

    private static boolean objectsEqual(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }
}

