/*
 * Decompiled with CFR 0.152.
 */
package chaschev.lang.reflect;

import chaschev.lang.reflect.ConstructorDesc;
import chaschev.lang.reflect.HavingMethodSignature;
import chaschev.lang.reflect.MethodDesc;
import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassDesc<T> {
    private static final Map<Class, ClassDesc> CLASS_DESC_MAP = new HashMap<Class, ClassDesc>();
    Class<T> aClass;
    public final Field[] fields;
    public final Field[] staticFields;
    public final MethodDesc[] staticMethods;
    public final MethodDesc[] methods;
    public final ConstructorDesc[] constructors;
    public static final Comparator<MethodDesc> METHOD_COMPARATOR = new Comparator<MethodDesc>(){

        @Override
        public int compare(MethodDesc o1, MethodDesc o2) {
            return o1.method.getName().compareTo(o1.method.getName());
        }
    };
    public static final Comparator<Field> FIELD_COMPARATOR = new Comparator<Field>(){

        @Override
        public int compare(Field o1, Field o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ClassDesc<T> getClassDesc(Class<T> aClass) {
        Preconditions.checkNotNull(aClass, (Object)"class must not be null");
        ClassDesc<T> result = CLASS_DESC_MAP.get(aClass);
        if (result == null) {
            result = new ClassDesc<T>(aClass);
            Map<Class, ClassDesc> map = CLASS_DESC_MAP;
            synchronized (map) {
                CLASS_DESC_MAP.put(aClass, result);
            }
        }
        return result;
    }

    ClassDesc(Class aClass) {
        int i;
        this.aClass = aClass;
        ArrayList<Field> tempFields = new ArrayList<Field>();
        ArrayList<Field> tempStaticFields = new ArrayList<Field>();
        ArrayList<Method> tempMethods = new ArrayList<Method>();
        ArrayList<Method> tempStaticMethods = new ArrayList<Method>();
        Constructor<?>[] constructors = aClass.getDeclaredConstructors();
        this.constructors = new ConstructorDesc[constructors.length];
        for (i = 0; i < constructors.length; ++i) {
            Constructor<?> constructor = constructors[i];
            this.constructors[i] = new ConstructorDesc(constructor);
        }
        while (aClass != Object.class && aClass != null) {
            Method[] methods;
            Field[] fields;
            for (Field field : fields = aClass.getDeclaredFields()) {
                field.setAccessible(true);
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers)) {
                    tempStaticFields.add(field);
                    continue;
                }
                tempFields.add(field);
            }
            for (Method method : methods = aClass.getDeclaredMethods()) {
                method.setAccessible(true);
                int modifiers = method.getModifiers();
                if (Modifier.isStatic(modifiers)) {
                    tempStaticMethods.add(method);
                    continue;
                }
                tempMethods.add(method);
            }
            aClass = aClass.getSuperclass();
        }
        this.fields = new Field[tempFields.size()];
        tempFields.toArray(this.fields);
        this.staticFields = new Field[tempStaticFields.size()];
        tempStaticFields.toArray(this.staticFields);
        this.methods = new MethodDesc[tempMethods.size()];
        this.staticMethods = new MethodDesc[tempStaticMethods.size()];
        for (i = 0; i < tempMethods.size(); ++i) {
            this.methods[i] = new MethodDesc((Method)tempMethods.get(i));
        }
        for (i = 0; i < tempStaticMethods.size(); ++i) {
            this.staticMethods[i] = new MethodDesc((Method)tempStaticMethods.get(i));
        }
        Arrays.sort(this.fields, FIELD_COMPARATOR);
        Arrays.sort(this.staticFields, FIELD_COMPARATOR);
        Arrays.sort(this.methods, METHOD_COMPARATOR);
        Arrays.sort(this.staticMethods, METHOD_COMPARATOR);
    }

    @Nullable
    public Field getField(String name) {
        return ClassDesc.findField(this.fields, name);
    }

    @Nullable
    public Field getStaticField(String name) {
        return ClassDesc.findField(this.staticFields, name);
    }

    @Nullable
    private static Field findField(Field[] array, String name) {
        for (Field field : array) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    private MethodDesc getMethodQuickly(String name, MethodDesc[] methods) {
        for (MethodDesc method : methods) {
            if (!method.method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public ConstructorDesc<T> getConstructorDesc(boolean strictly, Class ... parameters) {
        return (ConstructorDesc)this.findSignature((String)null, strictly, (HavingMethodSignature[])this.constructors, parameters);
    }

    public ConstructorDesc<T> getConstructorDesc(boolean strictly, Object ... parameters) {
        return (ConstructorDesc)this.findSignature(null, strictly, (HavingMethodSignature[])this.constructors, parameters);
    }

    public MethodDesc getMethodDesc(String name, boolean strictly, Object ... parameters) {
        return (MethodDesc)this.findSignature(name, strictly, (HavingMethodSignature[])this.methods, parameters);
    }

    public MethodDesc getMethodDesc(String name, boolean strictly, Class ... parameters) {
        return (MethodDesc)this.findSignature(name, strictly, (HavingMethodSignature[])this.methods, parameters);
    }

    public MethodDesc getStaticMethodDesc(String name, boolean strictly, Object ... parameters) {
        return (MethodDesc)this.findSignature(name, strictly, (HavingMethodSignature[])this.staticMethods, parameters);
    }

    protected HavingMethodSignature findSignature(@Nullable String name, boolean strictly, HavingMethodSignature[] signatures, Class[] parameters) {
        if (strictly) {
            for (HavingMethodSignature signature : signatures) {
                if (name != null && !name.equals(signature.getName()) || !signature.matchesStrictly(parameters)) continue;
                return signature;
            }
        } else {
            for (HavingMethodSignature signature : signatures) {
                if (name != null && !name.equals(signature.getName()) || !signature.matches(parameters)) continue;
                return signature;
            }
        }
        return null;
    }

    protected HavingMethodSignature findSignature(@Nullable String name, boolean strictly, HavingMethodSignature[] methodSignatures, Object[] parameters) {
        if (strictly) {
            for (HavingMethodSignature signature : methodSignatures) {
                if (name != null && !name.equals(signature.getName()) || !signature.matchesStrictly(parameters)) continue;
                return signature;
            }
        } else {
            HavingMethodSignature matchingSignature = null;
            for (HavingMethodSignature signature : methodSignatures) {
                if (name != null && !name.equals(signature.getName()) || !signature.matches(parameters)) continue;
                matchingSignature = signature;
                if (!signature.matchesStrictly(parameters)) continue;
                return signature;
            }
            return matchingSignature;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClassDesc{");
        sb.append("aClass=").append(this.aClass.getSimpleName());
        sb.append(", fields=").append(Arrays.toString(this.fields));
        sb.append('}');
        return sb.toString();
    }

    public T newInstance(Object ... params) {
        ConstructorDesc<T> constructorDesc = this.getConstructorDesc(false, params);
        if (constructorDesc == null) {
            throw new IllegalArgumentException("constructor not found for params: " + Arrays.asList(params));
        }
        return constructorDesc.newInstance(params);
    }
}

