/*
 * Decompiled with CFR 0.152.
 */
package chaschev.lang.reflect;

import chaschev.lang.reflect.MethodDesc;
import com.google.common.primitives.Primitives;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HavingMethodSignature {
    protected final Class<?>[] params;

    public HavingMethodSignature(Class<?>[] params) {
        this.params = params;
    }

    public boolean matchesStrictly(Class ... parameters) {
        return Arrays.equals(this.params, parameters);
    }

    public boolean matches(Object ... parameters) {
        if (!this.checkLength(parameters)) {
            return false;
        }
        int length = parameters.length;
        for (int i = 0; i < length; ++i) {
            boolean matches = HavingMethodSignature._matches(parameters[i].getClass(), this.params[i]);
            if (matches) continue;
            return false;
        }
        return true;
    }

    public boolean matchesStrictly(Object ... parameters) {
        if (!this.checkLength(parameters)) {
            return false;
        }
        int length = parameters.length;
        for (int i = 0; i < length; ++i) {
            if (this.params[i] == parameters[i].getClass()) continue;
            return false;
        }
        return true;
    }

    public boolean matches(Class ... parameters) {
        if (!this.checkLength(parameters)) {
            return false;
        }
        int length = parameters.length;
        for (int i = 0; i < length; ++i) {
            boolean matches = HavingMethodSignature._matches(parameters[i], this.params[i]);
            if (matches) continue;
            return false;
        }
        return true;
    }

    private static boolean _matches(Class inputParam, Class<?> declaredParam) {
        boolean matches = true;
        if (!(declaredParam.isAssignableFrom(inputParam) || inputParam.isPrimitive() && Primitives.wrap((Class)inputParam) == declaredParam || declaredParam.isPrimitive() && Primitives.wrap(declaredParam) == inputParam)) {
            matches = false;
        }
        return matches;
    }

    private boolean checkLength(Object[] parameters) {
        return this.params.length == parameters.length;
    }

    public abstract String getName();

    public String toString() {
        StringBuilder sb = new StringBuilder(128).append(this.getName()).append("(");
        int l = this.params.length;
        for (int i = 0; i < l; ++i) {
            Class<?> param = this.params[i];
            sb.append(param.getSimpleName());
            if (i == l - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        boolean isMethod = this instanceof MethodDesc;
        if (isMethod) {
            sb.append(":");
        }
        sb.append(isMethod ? ((MethodDesc)this).method.getReturnType().getSimpleName() : "");
        return sb.toString();
    }
}

