/*
 * Decompiled with CFR 0.152.
 */
package chaschev.util;

import chaschev.util.DomUtils;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class DomBuilder {
    private final DocumentBuilderFactory builderFactory;
    public final Document document;
    private final DocumentBuilder builder;

    public DomBuilder(DocumentBuilderFactory builderFactory) {
        this.builderFactory = builderFactory;
        try {
            this.builder = builderFactory.newDocumentBuilder();
            this.document = this.builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public Node root() {
        Element el = this.document.getDocumentElement();
        if (el == null) {
            return this.document;
        }
        return el;
    }

    public Element child(Element parent, String name) {
        return DomUtils.child(parent, name);
    }

    public DomBuilder(Document document) {
        this.document = document;
        this.builder = null;
        this.builderFactory = null;
    }

    public static String documentToString(Document doc) {
        DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)doc.getImplementation());
        LSSerializer lsSerializer = domImplementation.createLSSerializer();
        return lsSerializer.writeToString(doc);
    }

    public DomBuilder() {
        this.builderFactory = DocumentBuilderFactory.newInstance();
        this.builderFactory.setValidating(false);
        this.builderFactory.setNamespaceAware(false);
        this.builderFactory.setCoalescing(false);
        try {
            this.builder = this.builderFactory.newDocumentBuilder();
            this.document = this.builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public Element newElement(Node parent, String childName) {
        Element element = this.document.createElement(childName);
        parent.appendChild(element);
        return element;
    }

    public Text addTextNode(Node parent, String text) {
        Text textNode = this.document.createTextNode(text);
        parent.appendChild(textNode);
        return textNode;
    }

    public CDATASection addCDATA(Node parent, String text) {
        CDATASection section = this.document.createCDATASection(text);
        parent.appendChild(section);
        return section;
    }

    public String asString() {
        return DomBuilder.documentToString(this.document);
    }
}

