/*
 * Decompiled with CFR 0.152.
 */
package chaschev.util;

import chaschev.util.Exceptions;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomUtils {
    public static final Predicate<Node> TRUE = new Predicate<Node>(){

        @Override
        public boolean apply(Node node) {
            return true;
        }
    };

    public static Element child(Element element, String tag) {
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            if (item.getNodeType() != 1 || !DomUtils.hasLocalName(item, tag)) continue;
            return (Element)item;
        }
        return null;
    }

    public static boolean hasLocalName(Node item, String tag) {
        String nodeName = item.getNodeName();
        if (nodeName.endsWith(tag)) {
            int i = nodeName.length() - tag.length();
            return i == 0 || nodeName.charAt(i - 1) == ':';
        }
        return false;
    }

    public static Element childPath(Element element, String path) {
        String[] elements;
        for (String s : elements = path.split("/")) {
            if ((element = DomUtils.child(element, s)) != null) continue;
            return null;
        }
        return element;
    }

    public static Iterable<Element> children(Element element, final String tag) {
        return DomUtils.children(element, new Predicate<Node>(){

            @Override
            public boolean apply(Node node) {
                return DomUtils.hasLocalName(node, tag);
            }
        });
    }

    public static Iterable<Element> children(Element element) {
        return DomUtils.children(element, TRUE);
    }

    public static Iterable<Element> children(final Element element, final Predicate<Node> predicate) {
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return new Iterator<Element>(){
                    final NodeList list;
                    int i;
                    {
                        this.list = element.getChildNodes();
                        this.i = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        Node node;
                        while (!(this.i >= this.list.getLength() || (node = this.list.item(this.i)).getNodeType() == 1 && predicate.apply(node))) {
                            ++this.i;
                        }
                        return this.i < this.list.getLength();
                    }

                    @Override
                    public Element next() {
                        return (Element)this.list.item(this.i++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("todo .remove");
                    }
                };
            }
        };
    }

    public static String getAttribute(Element element, String attribute) {
        return element.getAttribute(attribute);
    }

    public static List<String> childrenText(Element parentElement, String tagname) {
        Iterable<Element> children = DomUtils.children(parentElement, tagname);
        ArrayList<String> result = new ArrayList<String>();
        for (Element element : children) {
            result.add(DomUtils.elementText(element));
        }
        return result;
    }

    public static String elementText(Element parentElement) {
        if (parentElement == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        NodeList childNodes = parentElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node == null || node.getNodeType() != 3) continue;
            result.append(((Text)node).getData());
        }
        return result.toString().trim();
    }

    public static String elementToString(Node n) {
        return DomUtils.elementToString(n, 0, 4);
    }

    public static String elementToString(Node node, int depth, int maxDepth) {
        return DomUtils.elementToString(node, new HashSet<Node>(), depth, maxDepth);
    }

    private static String elementToString(Node n, Set<Node> visitedSet, int depth, int maxDepth) {
        if (depth >= maxDepth) {
            return "depth limit\n";
        }
        if (visitedSet.contains(n)) {
            return "cycle to " + n.getLocalName() + "\n";
        }
        visitedSet.add(n);
        String name = n.getNodeName();
        short type = n.getNodeType();
        if (4 == type) {
            return "<![CDATA[" + n.getNodeValue() + "]]&gt;";
        }
        if (name.startsWith("#")) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('<').append(name);
        NamedNodeMap attrs = n.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                sb.append(' ').append(attr.getNodeName()).append("=\"").append(attr.getNodeValue()).append("\"");
            }
        }
        String textContent = null;
        NodeList children = n.getChildNodes();
        if (children.getLength() == 0) {
            textContent = DomUtils.getTextContent(n);
            if (textContent != null && !"".equals(textContent)) {
                sb.append(textContent).append("</").append(name).append('>');
            } else {
                sb.append("/>").append('\n');
            }
        } else {
            sb.append('>').append('\n');
            boolean hasValidChildren = false;
            for (int i = 0; i < children.getLength(); ++i) {
                String childToString = DomUtils.elementToString(children.item(i), visitedSet, depth + 1, maxDepth);
                if ("".equals(childToString)) continue;
                sb.append(childToString);
                hasValidChildren = true;
            }
            if (!hasValidChildren && (textContent = DomUtils.getTextContent(n)) != null) {
                sb.append(textContent);
            }
            sb.append("</").append(name).append('>');
        }
        return sb.toString();
    }

    public static String getTextContent(Node n) {
        if (n == null) {
            return null;
        }
        Node n1 = DomUtils.getChild(n, 3);
        if (n1 == null) {
            return null;
        }
        String s1 = n1.getNodeValue();
        return s1.trim();
    }

    public static Node getChild(Node parent, int type) {
        Node n;
        for (n = parent.getFirstChild(); n != null && type != n.getNodeType(); n = n.getNextSibling()) {
        }
        if (n == null) {
            return null;
        }
        return n;
    }

    public static Document parseXml(String s) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setIgnoringElementContentWhitespace(true);
            dbFactory.setNamespaceAware(false);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new ByteArrayInputStream(s.getBytes()));
            return doc;
        }
        catch (Exception e) {
            throw Exceptions.runtime(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Predicate<T> {
        public boolean apply(T var1);
    }
}

