/*
 * Decompiled with CFR 0.152.
 */
package chaschev.util;

import chaschev.util.DomBuilder;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class JsonXML {
    public static final JsonFactory JSON_FACTORY = new JsonFactory();

    public static String domToJson(Node in) throws IOException {
        StringWriter sw = new StringWriter(512);
        JsonGenerator gen = JSON_FACTORY.createGenerator((Writer)sw);
        gen.useDefaultPrettyPrinter();
        gen.writeStartObject();
        JsonXML.domToJson(in, gen);
        gen.writeEndObject();
        gen.flush();
        sw.flush();
        return sw.toString();
    }

    public static void domToJson(Node in, JsonGenerator out) throws IOException {
        JsonXML.domToJson(in, out, 1);
        out.flush();
    }

    protected static void domToJson(Node in, JsonGenerator out, int index) throws IOException {
        int n;
        out.writeObjectFieldStart(in.getNodeName() + "@" + index);
        NamedNodeMap attrs = in.getAttributes();
        if (attrs != null) {
            n = attrs.getLength();
            for (int i = 0; i < n; ++i) {
                Node item = attrs.item(i);
                String value = item.getNodeValue();
                out.writeStringField("@" + item.getNodeName(), value);
            }
        }
        NodeList childNodes = in.getChildNodes();
        n = childNodes.getLength();
        int i = 0;
        int jsonIndex = 1;
        while (i < n) {
            Node item = childNodes.item(i);
            if (item instanceof Element) {
                JsonXML.domToJson(item, out, jsonIndex);
            } else if (item instanceof Text) {
                Text text = (Text)item;
                String wholeText = text.getWholeText();
                if (JsonXML.isBlank(wholeText)) {
                    --jsonIndex;
                } else {
                    out.writeStringField("/text@" + jsonIndex, wholeText);
                }
            } else if (item instanceof CDATASection) {
                CDATASection cdata = (CDATASection)item;
                out.writeStringField("/cdata@" + jsonIndex, cdata.getWholeText());
            } else {
                throw new UnsupportedOperationException("todo: " + in.getNodeName() + ", class: " + item.getClass().getSimpleName());
            }
            ++i;
            ++jsonIndex;
        }
        out.writeEndObject();
    }

    private static boolean isBlank(String s) {
        int l = s.length();
        block3: for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\u00a0': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static DomBuilder jsonToDom(JsonNode node) throws IOException {
        DomBuilder b = new DomBuilder();
        JsonXML.jsonToDom(node, b.root(), b);
        return b;
    }

    public static void jsonToDom(JsonNode node, Node container, DomBuilder b) throws IOException {
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Map.Entry e = (Map.Entry)fields.next();
            String key = (String)e.getKey();
            if (key.startsWith("@")) {
                ((Element)container).setAttribute(key.substring(1), ((JsonNode)e.getValue()).textValue());
                continue;
            }
            if (key.startsWith("/")) {
                String directive = JsonXML.getName(1, key);
                if ("text".equals(directive)) {
                    b.addTextNode(container, ((JsonNode)e.getValue()).textValue());
                    continue;
                }
                throw new UnsupportedOperationException("unknown directive: " + directive);
            }
            Element element = b.newElement(container, JsonXML.getName(key));
            JsonXML.jsonToDom((JsonNode)e.getValue(), element, b);
        }
    }

    private static String getName(String key) {
        return JsonXML.getName(0, key);
    }

    private static String getName(int beginIndex, String key) {
        int i = key.lastIndexOf(64);
        if (i == -1) {
            i = key.length();
        }
        return key.substring(beginIndex, i);
    }
}

