/*
 * Decompiled with CFR 0.152.
 */
package chaschev.util;

import chaschev.util.MapObjectList;
import chaschev.util.MapObjectMap;
import chaschev.util.MapObjectUtils;
import chaschev.util.MapVisitor;
import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapObjectBase
extends MapObjectMap
implements MapObjectList {
    public Object obj;

    public MapObjectBase() {
    }

    public MapObjectBase(Object obj) {
        this.reuse(obj);
    }

    public MapObjectBase reuse(Object obj) {
        this.obj = obj;
        return this;
    }

    @Override
    public Iterator<MapObjectBase> iterator() {
        if (this.obj == null) {
            return Iterators.emptyIterator();
        }
        Iterator iterator = ((Iterable)this.obj).iterator();
        final MapObjectBase nav = new MapObjectBase();
        return Iterators.transform(iterator, (Function)new Function<Object, MapObjectBase>(){

            public MapObjectBase apply(Object input) {
                return nav.reuse(input);
            }
        });
    }

    @Override
    public MapObjectBase get(int n) {
        this.obj = ((List)this.obj).get(n);
        return this;
    }

    @Override
    public MapObjectList newCollection(String path) {
        return this.dup().gotoCollection(path);
    }

    @Override
    public MapObjectList gotoCollection(String path) {
        if (this.obj == null) {
            return this;
        }
        this.obj = MapObjectUtils.pathToCollection((Map)this.obj, path);
        return this;
    }

    @Override
    public MapObjectMap gotoMap(String path) {
        this.obj = MapObjectUtils.pathToMap((Map)this.obj, path);
        return this;
    }

    @Override
    public MapObjectMap having(String field1, Object value1) {
        if (this.obj == null) {
            return this;
        }
        this.obj = MapObjectUtils.having((Collection)this.obj, field1, value1);
        return this;
    }

    @Override
    public MapObjectMap having(String field1, Object value1, String field2, Object value2) {
        if (this.obj == null) {
            return this;
        }
        this.obj = MapObjectUtils.having((Collection)this.obj, field1, value1, field2, value2);
        return this;
    }

    @Override
    public int size() {
        if (this.obj == null) {
            return 0;
        }
        if (this.isCollection()) {
            return ((Collection)this.obj).size();
        }
        if (this.isMap()) {
            return ((Map)this.obj).size();
        }
        return 0;
    }

    public boolean isMap() {
        return this.obj instanceof Map;
    }

    public final Object value() {
        return this.obj;
    }

    @Override
    public final Map<String, Object> asMap() {
        return (Map)this.obj;
    }

    @Override
    public final Collection<Object> asCollection() {
        return (Collection)this.obj;
    }

    public final MapObjectMap asNavMap() {
        return this;
    }

    public final MapObjectList asNavCollection() {
        return this;
    }

    @Override
    public Object get(String key) {
        if (this.obj == null) {
            return this;
        }
        return this.asMap().get(key);
    }

    @Override
    public String getString(String key, String ifNull) {
        Object o = this.get(key);
        if (o == null || o instanceof MapObjectBase) {
            return ifNull;
        }
        return o.toString();
    }

    @Override
    public MapObjectBase dup() {
        return new MapObjectBase(this.obj);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MapObjectNav{");
        sb.append("obj=").append(this.obj);
        sb.append('}');
        return sb.toString();
    }

    public void acceptVisitor(MapVisitor mapVisitor) {
        this.acceptVisitor(mapVisitor, null, null);
    }

    protected void acceptVisitor(MapVisitor mapVisitor, Object parent, Iterator<Object> parentIterator) {
        Iterator<Object> iterator;
        boolean isCollection = this.isCollection();
        boolean wasRemoved = isCollection ? mapVisitor.visitBefore(this, parent, (Iterator)parentIterator) : mapVisitor.visitBefore(this, parent, (Iterator)parentIterator);
        MapObjectBase thisMapObj = this;
        Object thisObj = thisMapObj.obj;
        Iterator<Object> iterator2 = iterator = isCollection ? this.asCollection().iterator() : this.asMap().values().iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (o instanceof Collection) {
                thisMapObj.obj = o;
                thisMapObj.acceptVisitor(mapVisitor, thisObj, iterator);
                continue;
            }
            if (!(o instanceof Map)) continue;
            thisMapObj.obj = o;
            thisMapObj.acceptVisitor(mapVisitor, thisObj, iterator);
        }
        thisMapObj.obj = thisObj;
        if (!wasRemoved) {
            if (isCollection) {
                mapVisitor.visitAfter(this, parent, (Iterator)parentIterator);
            } else {
                mapVisitor.visitAfter(this, parent, (Iterator)parentIterator);
            }
        }
    }

    public boolean isCollection() {
        return this.obj instanceof Collection;
    }
}

