/*
 * Decompiled with CFR 0.152.
 */
package chaschev.util;

import chaschev.util.DomBuilder;
import chaschev.util.Exceptions;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapObjectUtils {
    public static void clean(Collection l) {
        MapObjectUtils.cleanCollection(l);
    }

    public static Map pathToMap(Map<String, Object> mapObject, String path) {
        if (mapObject == null) {
            return null;
        }
        String[] split = path.split("/");
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            Object o = mapObject.get(s);
            if (!(o instanceof Map)) {
                if (o instanceof Collection) {
                    throw new IllegalStateException("expected map, found collection");
                }
                return null;
            }
            mapObject = (Map)o;
        }
        return mapObject;
    }

    public static Object pathToItem(Map<String, Object> mapObject, String path, int n) {
        return MapObjectUtils.pathToList(mapObject, path).get(n);
    }

    public static List<Object> pathToList(Map<String, Object> mapObject, String path) {
        return (List)MapObjectUtils.pathToCollection(mapObject, path);
    }

    public static Collection pathToCollection(Map<String, Object> mapObject, String path) {
        String[] split = path.split("/");
        int length = split.length;
        for (int i = 0; i < length; ++i) {
            String s = split[i];
            Object o = mapObject.get(s);
            if (i == length - 1) {
                if (!(o instanceof Collection)) {
                    if (o instanceof Map) {
                        throw new IllegalStateException("collection expected, but found map");
                    }
                    return null;
                }
                return (Collection)o;
            }
            if (!(o instanceof Map)) {
                return null;
            }
            mapObject = (Map)o;
        }
        return null;
    }

    public static Map<String, Object> having(Collection collection, String field, Object value) {
        for (Object o : collection) {
            Map map;
            if (!(o instanceof Map) || !Objects.equals(value, (map = (Map)o).get(field))) continue;
            return map;
        }
        return null;
    }

    public static Map<String, Object> having(Collection collection, String field1, Object value1, String field2, Object value2) {
        for (Object o : collection) {
            Map map;
            if (!(o instanceof Map) || !Objects.equals(value1, (map = (Map)o).get(field1)) || !Objects.equals(value2, map.get(field2))) continue;
            return map;
        }
        return null;
    }

    public static Map<String, Object> fromJSON(Reader is) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (Map)mapper.readValue(is, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw Exceptions.runtime(e);
        }
    }

    public static Map<String, Object> fromJSON(InputStream is) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (Map)mapper.readValue(is, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw Exceptions.runtime(e);
        }
    }

    public static Map<String, Object> fromJSON(String content) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (Map)mapper.readValue(content, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw Exceptions.runtime(e);
        }
    }

    public static String toJSON(Map<String, Object> map) {
        return MapObjectUtils.toJSON(map);
    }

    public static String toJSON(Object pojo) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            StringWriter sw = new StringWriter(51200);
            mapper.writeValue((Writer)sw, pojo);
            return sw.toString();
        }
        catch (IOException e) {
            throw Exceptions.runtime(e);
        }
    }

    protected static void cleanCollection(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String oString;
            Object o = iterator.next();
            if (o == null) {
                iterator.remove();
                continue;
            }
            if (o instanceof Collection) {
                Collection oColl = (Collection)o;
                if (oColl.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                MapObjectUtils.clean(oColl);
                if (!oColl.isEmpty()) continue;
                iterator.remove();
                continue;
            }
            if (o instanceof Map) {
                Map oMap = (Map)o;
                if (oMap.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                MapObjectUtils.clean(oMap);
                if (!oMap.isEmpty()) continue;
                iterator.remove();
                continue;
            }
            if (!(o instanceof String) || !(oString = (String)o).isEmpty()) continue;
            iterator.remove();
        }
    }

    public static void clean(Map mapObject) {
        MapObjectUtils.clean(mapObject.values());
    }

    public static String toXML(Map object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MapObjectUtils.toXML(object, baos);
        return baos.toString();
    }

    public static void toXML(Map object, OutputStream stream) {
        try {
            XMLOutputFactory factory = XMLOutputFactory.newFactory();
            XMLStreamWriter writer = factory.createXMLStreamWriter(stream);
            new XmlStreamCreator(writer).toXMLRec(object, writer);
            writer.flush();
            stream.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Document toDomXML(Map object) {
        try {
            DomBuilder b = new DomBuilder();
            MapObjectUtils.toDomXMLRec(object, b.document, b);
            return b.document;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void toDomXMLRec(Map object, Node parent, DomBuilder b) {
        Set set = object.entrySet();
        for (Map.Entry entry : set) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (MapObjectUtils.isSimpleValue(value)) {
                String s = value.toString();
                ((Element)parent).setAttribute(key.toString(), s);
                continue;
            }
            if (value instanceof Collection) {
                MapObjectUtils.toDomXMLRec((Collection)value, b.newElement(parent, key.toString()), b);
                continue;
            }
            if (!(value instanceof Map)) continue;
            MapObjectUtils.toDomXMLRec((Map)value, (Node)b.newElement(parent, key.toString()), b);
        }
    }

    private static boolean isSimpleValue(Object value) {
        return value instanceof String || value instanceof Number || value instanceof Date;
    }

    private static void toDomXMLRec(Collection list, Element parent, DomBuilder b) {
        for (Object o : list) {
            Element item = b.newElement(parent, "item");
            if (MapObjectUtils.isSimpleValue(o)) {
                b.addTextNode(item, o.toString());
                continue;
            }
            if (o instanceof Collection) {
                MapObjectUtils.toDomXMLRec((Collection)o, item, b);
                continue;
            }
            if (!(o instanceof Map)) continue;
            MapObjectUtils.toDomXMLRec((Map)o, (Node)item, b);
        }
    }

    private static class XmlStreamCreator {
        XMLStreamWriter writer;
        List<Map.Entry> attributes = new ArrayList<Map.Entry>();

        private XmlStreamCreator(XMLStreamWriter writer) {
            this.writer = writer;
        }

        private void toXMLRec(Collection list, XMLStreamWriter writer) throws Exception {
            for (Object o : list) {
                writer.writeStartElement("item");
                if (MapObjectUtils.isSimpleValue(o)) {
                    writer.writeCharacters(o.toString());
                } else if (o instanceof Collection) {
                    this.toXMLRec((Collection)o, writer);
                } else if (o instanceof Map) {
                    this.toXMLRec((Map)o, writer);
                }
                writer.writeEndElement();
            }
        }

        private void toXMLRec(Map object, XMLStreamWriter writer) throws Exception {
            Set set = object.entrySet();
            this.attributes.clear();
            for (Map.Entry entry : set) {
                if (!MapObjectUtils.isSimpleValue(entry.getValue())) continue;
                this.attributes.add(entry);
            }
            for (Map.Entry entry : this.attributes) {
                writer.writeAttribute(entry.getKey().toString(), entry.getValue().toString());
            }
            for (Map.Entry entry : set) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Collection) {
                    writer.writeStartElement(key.toString());
                    this.toXMLRec((Collection)value, writer);
                    writer.writeEndElement();
                    continue;
                }
                if (!(value instanceof Map)) continue;
                Map map = (Map)value;
                writer.writeStartElement(key.toString());
                this.toXMLRec(map, writer);
                writer.writeEndElement();
            }
        }
    }

    public static class Objects {
        public static boolean equals(Object a, Object b) {
            return a == b || a != null && a.equals(b);
        }
    }
}

