/*
 * Decompiled with CFR 0.152.
 */
package chaschev.util;

import chaschev.util.Exceptions;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevisionInfo {
    private static Logger logger = LoggerFactory.getLogger(RevisionInfo.class);
    private String artifactId;
    private String revision;
    private String version;
    private String buildTimestamp;
    private static volatile RevisionInfo instance;
    private final Class aClass;
    private final Properties props = new Properties();
    private Env env;

    public RevisionInfo() {
        this.aClass = null;
    }

    private RevisionInfo(Class aClass) {
        this.aClass = aClass;
    }

    public RevisionInfo init() {
        String moduleName = "build";
        InputStream is = null;
        try {
            is = this.aClass.getResourceAsStream("/build.properties");
            this.props.load(is);
            this.revision = this.props.getProperty("project.revision");
            this.version = this.props.getProperty("project.version");
            this.buildTimestamp = this.props.getProperty("project.buildTimestamp");
            this.artifactId = this.props.getProperty("project.artifactId");
            this.env = Env.valueOf(this.props.getProperty("project.env", "production"));
        }
        catch (Exception e) {
            logger.warn("Failed to read build.properties", (Throwable)e);
            this.revision = "<No revision info available>";
            throw Exceptions.runtime(e);
        }
        return this;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuildTimestamp() {
        return this.buildTimestamp;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String toString() {
        return String.format("%s v%s-%s r%s %s", this.artifactId, this.version, this.getEnvironment().concise(), this.revision, this.getBuildDate());
    }

    public String toShortString() {
        return String.format("%s v%s", this.artifactId, this.version);
    }

    public String getBuildDate() {
        if (this.buildTimestamp.matches("\\d+")) {
            return new SimpleDateFormat().format(new Date(Long.parseLong(this.buildTimestamp)));
        }
        return this.buildTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RevisionInfo get(Class aClass) {
        if (instance != null) return instance;
        Class<RevisionInfo> clazz = RevisionInfo.class;
        synchronized (RevisionInfo.class) {
            if (instance != null) return instance;
            instance = new RevisionInfo(aClass).init();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public boolean isDevelopment() {
        return this.env == Env.development;
    }

    public boolean isProduction() {
        return this.env == Env.production;
    }

    public boolean isTest() {
        return this.env == Env.test;
    }

    public Env getEnvironment() {
        return this.env;
    }

    public static void main(String[] args) {
        System.out.println(RevisionInfo.get(RevisionInfo.class).toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Env {
        development,
        production,
        test;


        public String concise() {
            switch (this) {
                case development: {
                    return "dev";
                }
                case production: {
                    return "prod";
                }
                case test: {
                    return "test";
                }
            }
            throw new IllegalStateException();
        }
    }
}

