/*
 * Decompiled with CFR 0.152.
 */
package com.bethecoder.table.impl;

import com.bethecoder.table.ASCIITableHeader;
import com.bethecoder.table.spec.IASCIITableAware;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCASCIITableAware
implements IASCIITableAware {
    private List<ASCIITableHeader> headers = null;
    private List<List<Object>> data = null;

    public JDBCASCIITableAware(Connection connection, String sql) {
        try {
            Statement stmt = connection.createStatement();
            ResultSet resultSet = stmt.executeQuery(sql);
            this.init(resultSet);
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to get table data : " + e);
        }
    }

    public JDBCASCIITableAware(ResultSet resultSet) {
        try {
            this.init(resultSet);
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to get table data : " + e);
        }
    }

    private void init(ResultSet resultSet) throws SQLException {
        int colCount = resultSet.getMetaData().getColumnCount();
        this.headers = new ArrayList<ASCIITableHeader>(colCount);
        for (int i = 0; i < colCount; ++i) {
            this.headers.add(new ASCIITableHeader(resultSet.getMetaData().getColumnLabel(i + 1).toUpperCase()));
        }
        this.data = new ArrayList<List<Object>>();
        ArrayList<Object> rowData = null;
        while (resultSet.next()) {
            rowData = new ArrayList<Object>();
            for (int i = 0; i < colCount; ++i) {
                rowData.add(resultSet.getObject(i + 1));
            }
            this.data.add(rowData);
        }
    }

    @Override
    public List<List<Object>> getData() {
        return this.data;
    }

    @Override
    public List<ASCIITableHeader> getHeaders() {
        return this.headers;
    }

    @Override
    public String formatData(ASCIITableHeader header, int row, int col, Object data) {
        try {
            BigDecimal bd = new BigDecimal(data.toString());
            return DecimalFormat.getInstance().format(bd);
        }
        catch (Exception e) {
            return null;
        }
    }
}

