/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.ui.eq;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zkmax.ui.eq.EventQueue;

class EventQueueImpl
implements EventQueue {
    private final Component _dummy = new AbstractComponent();
    private final List _listeners = new LinkedList();

    EventQueueImpl() {
        this._dummy.addEventListener("onQueue", new EventListener(){

            public void onEvent(Event event) throws Exception {
                Iterator it = EventQueueImpl.this._listeners.iterator();
                while (it.hasNext()) {
                    ((EventListener)it.next()).onEvent(event);
                }
            }
        });
    }

    public void publish(Event event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        Events.postEvent((String)"onQueue", (Component)this._dummy, (Object)event);
    }

    public void subscribe(EventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this._listeners.add(listener);
    }

    public boolean unsubscribe(EventListener listener) {
        return this._listeners.remove(listener);
    }
}

