/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.tests.special;

import java.util.HashMap;
import java.util.LinkedList;
import junit.framework.TestCase;
import org.mvel.TemplateInterpreter;

public class ThreadSafetyTests
extends TestCase {
    private static final int TOTAL_THREADS = 5;
    private static final int RUNCOUNT = 1000;
    private Thread[] threads;

    public void testMultiIteratorMultiThread() {
        this.threads = new Thread[5];
        int i = 0;
        while (i < 5) {
            this.threads[i] = new Thread(new TestRunner(this, i));
            ++i;
        }
        i = 0;
        while (i < 5) {
            this.threads[i].setPriority(1);
            this.threads[i].start();
            ++i;
        }
        while (this.areThreadsActive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        System.out.println("Done.");
    }

    private boolean areThreadsActive() {
        int i = 0;
        while (i < 5) {
            if (this.threads[i].isAlive()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void testMultiIterator() {
        HashMap m = new HashMap();
        LinkedList<String> x = new LinkedList<String>();
        x.add("foo");
        x.add("bar");
        LinkedList<String> y = new LinkedList<String>();
        y.add("FOO");
        y.add("BAR");
        m.put("x", x);
        m.put("y", y);
        TemplateInterpreter.eval("@foreach{x as item1, y as item2}X:@{item1};Y:@{item2}@end{}", m);
    }

    public static class TestRunner
    implements Runnable {
        private ThreadSafetyTests tst;
        private int threadNumber;

        public TestRunner(ThreadSafetyTests tst, int threadNumber) {
            this.tst = tst;
            this.threadNumber = threadNumber;
        }

        public void run() {
            System.out.println("Thread " + this.threadNumber + " started.");
            int i = 0;
            while (i < 1000) {
                this.tst.testMultiIterator();
                ++i;
            }
            System.out.println("Thread " + this.threadNumber + " ended.");
        }
    }
}

