/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.mvel.util.ParseTools;

public class CollectionParser {
    private char[] property;
    private int cursor;
    private int length;
    private int start;
    private int type;
    public static final int LIST = 0;
    public static final int ARRAY = 1;
    public static final int MAP = 2;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public CollectionParser() {
    }

    public CollectionParser(int type) {
        this.type = type;
    }

    public Object parseCollection(char[] property) {
        this.cursor = 0;
        this.property = property;
        this.length = property.length;
        if (this.length > 0) {
            while (this.length > 0 && Character.isWhitespace(property[this.length - 1])) {
                --this.length;
            }
        }
        return this.parseCollection();
    }

    private Object parseCollection() {
        if (this.length == 0) {
            if (this.type == 0) {
                return new ArrayList();
            }
            return EMPTY_ARRAY;
        }
        HashMap<String, Object> map = null;
        ArrayList<Object> list = null;
        if (this.type != -1) {
            switch (this.type) {
                case 0: 
                case 1: {
                    list = new ArrayList<Object>();
                    break;
                }
                case 2: {
                    map = new HashMap<String, Object>();
                }
            }
        }
        Object curr = null;
        int newType = -1;
        while (this.cursor < this.length) {
            switch (this.property[this.cursor]) {
                case '{': {
                    if (newType == -1) {
                        newType = 1;
                    }
                }
                case '[': {
                    if (newType == -1) {
                        newType = 0;
                    }
                    this.start = this.cursor;
                    this.cursor = ParseTools.balancedCapture(this.property, this.start, this.property[this.start]);
                    Object o = new CollectionParser(newType).parseCollection(CollectionParser.subset(this.property, this.start + 1, this.cursor));
                    if (this.type == 2) {
                        map.put((String)curr, o);
                    } else {
                        curr = o;
                        list.add(curr);
                    }
                    this.start = ++this.cursor;
                    if (this.cursor >= this.length - 1 || this.property[this.cursor] != ',') break;
                    this.start = this.cursor + 1;
                    break;
                }
                case '(': {
                    this.cursor = ParseTools.balancedCapture(this.property, this.cursor, this.property[this.cursor]);
                    if (this.cursor != -1) break;
                    throw new RuntimeException("unbalanced braces inside inline collection");
                }
                case '\"': 
                case '\'': {
                    this.cursor = ParseTools.balancedCapture(this.property, this.cursor, this.property[this.cursor]);
                    if (this.cursor != -1) break;
                    throw new RuntimeException("unterminated string literal starting at index " + this.start + " {" + this.property[this.start] + "}: " + new String(this.property));
                }
                case ',': {
                    if (this.type != 2) {
                        list.add(new String(this.property, this.start, this.cursor - this.start));
                    } else {
                        map.put((String)curr, new String(this.property, this.start, this.cursor - this.start).trim());
                    }
                    this.start = this.cursor + 1;
                    break;
                }
                case ':': {
                    if (this.type != 2) {
                        map = new HashMap();
                        this.type = 2;
                    }
                    curr = new String(this.property, this.start, this.cursor - this.start).trim();
                    this.start = this.cursor + 1;
                }
            }
            ++this.cursor;
        }
        if (this.start < this.length) {
            if (this.cursor < this.length - 1) {
                ++this.cursor;
            }
            if (this.type == 2) {
                map.put((String)curr, new String(this.property, this.start, this.cursor - this.start).trim());
            } else {
                if (this.cursor < this.length) {
                    ++this.cursor;
                }
                list.add(new String(this.property, this.start, this.cursor - this.start).trim());
            }
        }
        switch (this.type) {
            case 2: {
                return map;
            }
            case 1: {
                return list.toArray();
            }
        }
        return list;
    }

    private static char[] subset(char[] property, int start, int end) {
        while (start < end - 1 && Character.isWhitespace(property[start])) {
            ++start;
        }
        char[] newA = new char[end - start];
        System.arraycopy(property, start, newA, 0, end - start);
        return newA;
    }

    public int getCursor() {
        return this.cursor;
    }
}

