/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.zkoss.gmaps.Ginfo;
import org.zkoss.gmaps.GmapsUtil;
import org.zkoss.gmaps.Gmarker;
import org.zkoss.gmaps.LatLng;
import org.zkoss.gmaps.LatLngBounds;
import org.zkoss.gmaps.MapModel;
import org.zkoss.gmaps.Mapitem;
import org.zkoss.gmaps.MapitemRenderer;
import org.zkoss.gmaps.event.InfoChangeEvent;
import org.zkoss.gmaps.event.MapDataEvent;
import org.zkoss.gmaps.event.MapDataListener;
import org.zkoss.gmaps.event.MapDropEvent;
import org.zkoss.gmaps.event.MapMouseEvent;
import org.zkoss.gmaps.event.MapMoveEvent;
import org.zkoss.gmaps.event.MapTypeChangeEvent;
import org.zkoss.gmaps.event.MapZoomEvent;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.Express;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.XulElement;

public class Gmaps
extends XulElement {
    private static final long serialVersionUID = 200807040842L;
    private transient Ginfo _oneinfo;
    private transient Ginfo _info;
    private LatLng _center = new LatLng(37.4419, -122.1419);
    private LatLngBounds _bounds = new LatLngBounds(new LatLng(37.41802693231111, -122.1933746338), new LatLng(37.4657298516, -122.0903778076));
    private int _zoom = 13;
    private boolean _large;
    private boolean _small;
    private boolean _type = true;
    private boolean _smallZoom = true;
    private boolean _pan = true;
    private boolean _scale;
    private boolean _overview;
    private boolean _normal = true;
    private boolean _satellite;
    private boolean _hybrid = true;
    private boolean _physical = true;
    private String _mapType = "normal";
    private boolean _enableDragging = true;
    private boolean _continuousZoom;
    private boolean _doubleClickZoom = true;
    private boolean _scrollWheelZoom = true;
    private boolean _enableGoogleBar;
    private boolean _sensor;
    private String _baseDomain;
    private String _client;
    private String _language;
    private String _libraries = "geometry";
    private String _protocol;
    private MapModel _model;
    private MapitemRenderer _renderer;
    private MapDataListener _dataListener;
    private EventListener _moveListener;
    private Map _dataMap = new HashMap(64);
    private Component _selected;
    private String _version = "3";

    public void setCenter(double lat, double lng) {
        this.setCenter(new LatLng(lat, lng));
    }

    public void setCenter(LatLng center) {
        if (center == null) {
            throw new NullPointerException("center");
        }
        if (!Objects.equals((Object)((Object)this._center), (Object)((Object)center))) {
            this._center = center;
            this.smartUpdate("center", (Object)center);
        }
    }

    public LatLng getCenter() {
        return this._center;
    }

    public void setClient(String client) {
        if (!Objects.equals((Object)this._client, (Object)client)) {
            this._client = client;
            this.smartUpdate("client", client);
        }
    }

    public String getClient() {
        return this._client;
    }

    public void setLat(double lat) {
        this.setCenter(new LatLng(lat, this._center.getLongitude()));
    }

    public double getLat() {
        return this._center.getLatitude();
    }

    public void setLng(double lng) {
        this.setCenter(new LatLng(this._center.getLatitude(), lng));
    }

    public double getLng() {
        return this._center.getLongitude();
    }

    public void fitBounds(LatLngBounds bounds) {
        if (bounds == null) {
            throw new NullPointerException("bounds");
        }
        if (!Objects.equals((Object)((Object)this._bounds), (Object)((Object)bounds))) {
            this._bounds = bounds;
            this.syncModel();
            this.smartUpdate("bounds", (Object)bounds);
        }
    }

    public LatLngBounds getBounds() {
        return this._bounds;
    }

    public double getSwLat() {
        return this.getSwlat();
    }

    public double getSwlat() {
        return this._bounds.getSouthWest().getLatitude();
    }

    public void setSwlat(double swlat) {
        this.fitBounds(new LatLngBounds(new LatLng(swlat, this._bounds.getSouthWest().getLongitude()), this._bounds.getNorthEast()));
    }

    public double getSwLng() {
        return this.getSwlng();
    }

    public double getSwlng() {
        return this._bounds.getSouthWest().getLongitude();
    }

    public void setSwlng(double swlng) {
        this.fitBounds(new LatLngBounds(new LatLng(this._bounds.getSouthWest().getLatitude(), swlng), this._bounds.getNorthEast()));
    }

    public double getNeLat() {
        return this.getNelat();
    }

    public double getNelat() {
        return this._bounds.getNorthEast().getLatitude();
    }

    public void setNelat(double nelat) {
        this.fitBounds(new LatLngBounds(this._bounds.getSouthWest(), new LatLng(nelat, this._bounds.getNorthEast().getLongitude())));
    }

    public double getNeLng() {
        return this.getNelng();
    }

    public double getNelng() {
        return this._bounds.getNorthEast().getLongitude();
    }

    public void setNelng(double nelng) {
        this.fitBounds(new LatLngBounds(this._bounds.getSouthWest(), new LatLng(this._bounds.getNorthEast().getLatitude(), nelng)));
    }

    public void panTo(double lat, double lng) {
        this.panTo(new LatLng(lat, lng));
    }

    public void panTo(LatLng center) {
        if (!this._center.equals((Object)center)) {
            this._center = center;
            this.smartUpdate("panTo_", (Object)center);
        }
    }

    public void setZoom(int zoom) {
        if (zoom != this._zoom) {
            this._zoom = zoom;
            this.smartUpdate("zoom", zoom);
        }
    }

    public int getZoom() {
        return this._zoom;
    }

    public void setShowLargeCtrl(boolean b) {
        if (this._large == b) {
            return;
        }
        this._large = b;
        if (b) {
            this.setShowSmallCtrl(false);
            this.setShowZoomCtrl(false);
        }
        this.smartUpdate("showLargeCtrl", b);
    }

    public boolean isShowLargeCtrl() {
        return this._large;
    }

    public void setShowSmallCtrl(boolean b) {
        if (this._small == b) {
            return;
        }
        this._small = b;
        if (b) {
            this.setShowLargeCtrl(false);
            this.setShowZoomCtrl(false);
        }
        this.smartUpdate("showSmallCtrl", b);
    }

    public boolean isShowSmallCtrl() {
        return this._small;
    }

    public void setShowZoomCtrl(boolean b) {
        if (this._smallZoom == b) {
            return;
        }
        this._smallZoom = b;
        if (b) {
            this.setShowLargeCtrl(false);
            this.setShowSmallCtrl(false);
        }
        this.smartUpdate("showZoomCtrl", b);
    }

    public boolean isShowZoomCtrl() {
        return this._smallZoom;
    }

    public void setShowTypeCtrl(boolean b) {
        if (this._type == b) {
            return;
        }
        this._type = b;
        this.smartUpdate("showTypeCtrl", b);
    }

    public boolean isShowTypeCtrl() {
        return this._type;
    }

    public void setShowPanCtrl(boolean b) {
        if (this._pan == b) {
            return;
        }
        this._pan = b;
        this.smartUpdate("showPanCtrl", b);
    }

    public boolean isShowPanCtrl() {
        return this._pan;
    }

    public void setShowScaleCtrl(boolean b) {
        if (this._scale == b) {
            return;
        }
        this._scale = b;
        this.smartUpdate("showScaleCtrl", b);
    }

    public boolean isShowScaleCtrl() {
        return this._scale;
    }

    public void setShowOverviewCtrl(boolean b) {
        if (this._overview == b) {
            return;
        }
        this._overview = b;
        this.smartUpdate("showOverviewCtrl", b);
    }

    public boolean isShowOverviewCtrl() {
        return this._overview;
    }

    public void setNormal(boolean b) {
        if (this._normal != b) {
            if (!b && "normal".equals(this._mapType)) {
                if (this.isHybrid()) {
                    this.setMapType("hybrid");
                } else if (this.isSatellite()) {
                    this.setMapType("satellite");
                } else if (this.isPhysical()) {
                    this.setMapType("physical");
                } else {
                    return;
                }
            }
            this._normal = b;
            this.smartUpdate("normal", b);
        }
    }

    public boolean isNormal() {
        return this._normal;
    }

    public void setSatellite(boolean b) {
        if (this._satellite != b) {
            if (!b && "satellite".equals(this._mapType)) {
                if (this.isNormal()) {
                    this.setMapType("normal");
                } else if (this.isHybrid()) {
                    this.setMapType("hybrid");
                } else if (this.isPhysical()) {
                    this.setMapType("physical");
                } else {
                    return;
                }
            }
            this._satellite = b;
            this.smartUpdate("satellite", b);
        }
    }

    public boolean isSatellite() {
        return this._satellite;
    }

    public void setHybrid(boolean b) {
        if (this._hybrid != b) {
            if (!b && "hybrid".equals(this._mapType)) {
                if (this.isNormal()) {
                    this.setMapType("normal");
                } else if (this.isSatellite()) {
                    this.setMapType("satellite");
                } else if (this.isPhysical()) {
                    this.setMapType("physical");
                } else {
                    return;
                }
            }
            this._hybrid = b;
            this.smartUpdate("hybrid", b);
        }
    }

    public boolean isHybrid() {
        return this._hybrid;
    }

    public void setPhysical(boolean b) {
        if (this._physical != b) {
            if (!b && "physical".equals(this._mapType)) {
                if (this.isNormal()) {
                    this.setMapType("normal");
                } else if (this.isHybrid()) {
                    this.setMapType("hybrid");
                } else if (this.isSatellite()) {
                    this.setMapType("satellite");
                } else {
                    return;
                }
            }
            this._physical = b;
            this.smartUpdate("physical", b);
        }
    }

    public boolean isPhysical() {
        return this._physical;
    }

    public String getMapType() {
        return this._mapType;
    }

    public void setMapType(String mapType) {
        if ("normal".equals(mapType)) {
            this.setNormal(true);
        } else if ("satellite".equals(mapType)) {
            this.setSatellite(true);
        } else if ("hybrid".equals(mapType)) {
            this.setHybrid(true);
        } else if ("physical".equals(mapType)) {
            this.setPhysical(true);
        } else {
            mapType = "normal";
            this.setNormal(true);
        }
        this._mapType = mapType;
        this.smartUpdate("mapType", mapType);
    }

    public void setEnableDragging(boolean b) {
        if (this._enableDragging != b) {
            this._enableDragging = b;
            this.smartUpdate("enableDragging", b);
        }
    }

    public boolean isEnableDragging() {
        return this._enableDragging;
    }

    public void setContinuousZoom(boolean b) {
        if (this._continuousZoom != b) {
            this._continuousZoom = b;
            this.smartUpdate("continuousZoom", b);
        }
    }

    public boolean isContinuousZoom() {
        return this._continuousZoom;
    }

    public void setDoubleClickZoom(boolean b) {
        if (this._doubleClickZoom != b) {
            this._doubleClickZoom = b;
            this.smartUpdate("doubleClickZoom", b);
        }
    }

    public boolean isDoubleClickZoom() {
        return this._doubleClickZoom;
    }

    public void setScrollWheelZoom(boolean b) {
        if (this._scrollWheelZoom != b) {
            this._scrollWheelZoom = b;
            this.smartUpdate("scrollWheelZoom", b);
        }
    }

    public boolean isScrollWheelZoom() {
        return this._scrollWheelZoom;
    }

    public void setEnableGoogleBar(boolean b) {
        if (this._enableGoogleBar != b) {
            this._enableGoogleBar = b;
            this.smartUpdate("enableGoogleBar", b);
        }
    }

    public boolean isEnableGoogleBar() {
        return this._enableGoogleBar;
    }

    public boolean isSensor() {
        return this._sensor;
    }

    public void setSensor(boolean sensor) {
        if (this._sensor != sensor) {
            this._sensor = sensor;
            this.smartUpdate("sensor", sensor);
        }
    }

    public String getBaseDomain() {
        return this._baseDomain;
    }

    public void setBaseDomain(String baseDomain) {
        if (!Objects.equals((Object)this._baseDomain, (Object)baseDomain)) {
            this._baseDomain = baseDomain;
            this.smartUpdate("baseDomain", baseDomain);
        }
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String protocol) {
        if (!Objects.equals((Object)this._protocol, (Object)protocol)) {
            this._protocol = protocol;
            this.smartUpdate("protocol", protocol);
        }
    }

    public String getLanguage() {
        return this._language;
    }

    public void setLanguage(String language) {
        if (!Objects.equals((Object)this._language, (Object)language)) {
            this._language = language;
            this.smartUpdate("language", language);
        }
    }

    public String getLibraries() {
        return this._libraries;
    }

    public void setLibraries(String libraries) {
        if (!Objects.equals((Object)this._libraries, (Object)libraries)) {
            this._libraries = libraries;
            this.smartUpdate("libraries", libraries);
        }
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        if (!Objects.equals((Object)this._version, (Object)version)) {
            this._version = version;
            this.smartUpdate("language", version);
        }
    }

    public void openInfo(Ginfo info) {
        if (info != null) {
            if (info.getParent() != this) {
                throw new UiException("The to be opened Ginfo or Gmarker must be child of this Gmaps!");
            }
            this._info = info;
            this.smartUpdate("openInfo_", info.getUuid());
        } else {
            this.closeInfo();
        }
    }

    public void closeInfo() {
        this._info = null;
        this.smartUpdate("closeInfo_", "");
    }

    public Ginfo getInfo() {
        return this._info;
    }

    public MapModel getModel() {
        return this._model;
    }

    public void setModel(MapModel model) {
        if (model != null) {
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeMapDataListener(this._dataListener);
                }
                this._model = model;
                this.initMapDataListener();
            }
            this.addOnMapMove();
            this.syncModel();
        } else {
            this.onMapDataChange(new MapDataEvent(this._model, 4, null));
            this._model.removeMapDataListener(this._dataListener);
            this.removeOnMapMove();
            this._model = null;
        }
    }

    private void addOnMapMove() {
        if (this._moveListener == null) {
            this._moveListener = new UpdateBoundsListener();
            this.addEventListener("onMapMove", this._moveListener);
        }
    }

    private void removeOnMapMove() {
        if (this._moveListener != null) {
            this.removeEventListener("onMapMove", this._moveListener);
        }
    }

    private void syncModel() {
        if (this.getSwlat() == 37.41802693231111) {
            this.initBounds();
        }
        if (this._model != null) {
            this.onMapDataChange(new MapDataEvent(this._model, 3, this._model.getItemsIn(this.getSwlat(), this.getSwlng(), this.getNelat(), this.getNelng(), this.getLat(), this.getLng(), this._zoom)));
        }
    }

    private void initMapDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new MapDataListener(){

                public void onChange(MapDataEvent event) {
                    Gmaps.this.onMapDataChange(event);
                }
            };
        }
        this._model.addMapDataListener(this._dataListener);
    }

    private void onMapDataChange(MapDataEvent event) {
        Ginfo info = null;
        switch (event.getType()) {
            case 1: {
                MapitemRenderer renderer = this.getRealRenderer();
                Iterator it = event.getItems().iterator();
                while (it.hasNext()) {
                    Object data = it.next();
                    Mapitem mitem = renderer.newMapitem(data);
                    if (info == null && mitem instanceof Ginfo && ((Ginfo)mitem).isOpen()) {
                        info = (Ginfo)mitem;
                    }
                    this._dataMap.put(data, mitem);
                    this.appendChild(mitem);
                }
                break;
            }
            case 2: {
                Iterator it = event.getItems().iterator();
                while (it.hasNext()) {
                    Object data = it.next();
                    Mapitem mitem = (Mapitem)this._dataMap.remove(data);
                    if (mitem == null) continue;
                    this.removeChild(mitem);
                }
                break;
            }
            case 0: {
                MapitemRenderer renderer = this.getRealRenderer();
                Collection items = event.getItems();
                Iterator it = items.iterator();
                while (it.hasNext()) {
                    Object data = it.next();
                    if (!this._dataMap.containsKey(data)) continue;
                    Mapitem mitem = (Mapitem)this._dataMap.remove(data);
                    boolean isopen = info == null && mitem instanceof Ginfo && ((Ginfo)mitem).isOpen();
                    this.removeChild(mitem);
                    Mapitem nitem = renderer.newMapitem(data);
                    if (isopen) {
                        info = (Ginfo)nitem;
                    }
                    this._dataMap.put(data, nitem);
                    this.appendChild(nitem);
                }
                break;
            }
            case 3: {
                MapitemRenderer renderer = this.getRealRenderer();
                Collection items = event.getItems();
                Iterator it = this._dataMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Object data = entry.getKey();
                    Mapitem mitem = (Mapitem)entry.getValue();
                    if (items.contains(data)) continue;
                    it.remove();
                    this.removeChild(mitem);
                }
                it = items.iterator();
                while (it.hasNext()) {
                    Map.Entry data = it.next();
                    if (this._dataMap.containsKey(data)) continue;
                    Mapitem mitem = renderer.newMapitem(data);
                    if (info == null && mitem instanceof Ginfo && ((Ginfo)mitem).isOpen()) {
                        info = (Ginfo)mitem;
                    }
                    this._dataMap.put(data, mitem);
                    this.appendChild(mitem);
                }
                break;
            }
            case 4: {
                Iterator it = this._dataMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Mapitem mitem = (Mapitem)entry.getValue();
                    this.removeChild(mitem);
                }
                this._dataMap.clear();
            }
        }
        if (info != null && info != this._info) {
            this.openInfo(info);
        }
    }

    private MapitemRenderer getRealRenderer() {
        return this._renderer == null ? new MapitemRenderer(){

            public Mapitem newMapitem(Object data) {
                return (Mapitem)data;
            }
        } : this._renderer;
    }

    public MapitemRenderer getItemRenderer() {
        return this._renderer;
    }

    public void setItemRenderer(MapitemRenderer renderer) {
        this._renderer = renderer;
    }

    public void setSelectedItem(Component item) {
        if (item == null) {
            this._selected = null;
        } else {
            if (item.getParent() != this) {
                throw new UiException("Not a child: " + item);
            }
            this._selected = item;
        }
    }

    public Component getSelectedItem() {
        return this._selected;
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (!(child instanceof Mapitem)) {
            throw new UiException("Only Mapitem such as Ginfo, Gmarker, Gpolyline, Gpolygon, Gimage, Gscreen is allowed to be child of Gmaps: " + (Object)((Object)this) + ", " + child);
        }
        if (this.isGinfo(child)) {
            if (this._oneinfo != null && this._oneinfo != child) {
                throw new UiException("Only one Ginfo is allowed: " + (Object)((Object)this));
            }
            this._oneinfo = (Ginfo)child;
        }
        boolean ret = super.insertBefore(child, insertBefore);
        if (child instanceof Ginfo && ((Ginfo)child).isOpen()) {
            this.openInfo((Ginfo)child);
        }
        return ret;
    }

    public void onChildRemoved(Component child) {
        if (this.isGinfo(child)) {
            this._oneinfo = null;
        }
        if (child == this._info) {
            this._info.setOpenByClient(false);
            this._info = null;
        }
        super.onChildRemoved(child);
    }

    private boolean isGinfo(Component comp) {
        return comp instanceof Ginfo && ((Ginfo)comp).isGinfo();
    }

    public Object clone() {
        Gmaps clone = (Gmaps)((Object)super.clone());
        if (clone._oneinfo != null || clone._info != null) {
            clone.afterUnmarshal();
        }
        return clone;
    }

    private void afterUnmarshal() {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (this.isGinfo((Component)child)) {
                this._oneinfo = (Ginfo)child;
            }
            if (this._info == null || ((Component)child).getUuid() != this._info.getUuid()) continue;
            this._info = (Ginfo)child;
            break;
        }
    }

    void setCenterByClient(LatLng center) {
        this._center = center;
    }

    void setZoomByClient(int zoom) {
        this._zoom = zoom;
    }

    void setMapTypeByClient(String type) {
        this._mapType = type;
    }

    void setInfoByClient(Ginfo info) {
        if (info != null) {
            info.setOpenByClient(false);
        } else if (this._info != null) {
            this._info.setOpenByClient(false);
        }
        this._info = info;
    }

    void setBoundsByClient(LatLngBounds bounds) {
        this._bounds = bounds;
    }

    private int width(String width) {
        if ((width = width.trim()).endsWith("%")) {
            return 1280;
        }
        return this.stringToInt(width);
    }

    private int height(String height) {
        if (height.endsWith("%")) {
            return 1024;
        }
        return this.stringToInt(height);
    }

    private int stringToInt(String str) {
        if (str.endsWith("px")) {
            str = str.substring(0, str.length() - 2);
        } else {
            if (str.endsWith("pt")) {
                str = str.substring(0, str.length() - 2);
                return (int)((double)Integer.parseInt(str) * 1.3333);
            }
            if (str.endsWith("em")) {
                str = str.substring(0, str.length() - 2);
                return (int)((double)Integer.parseInt(str) * 13.3333);
            }
        }
        return Integer.parseInt(str);
    }

    private void initBounds() {
        this._bounds = GmapsUtil.getBounds(this._center, this.width(this.getWidth()), this.height(this.getHeight()), this._zoom);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!this._center.equals((Object)new LatLng(37.4419, -122.1419))) {
            this.render(renderer, "center", (Object)this._center);
        }
        if (!this._bounds.equals((Object)new LatLngBounds(new LatLng(37.41802693231111, -122.1933746338), new LatLng(37.4657298516, -122.0903778076)))) {
            this.render(renderer, "bounds", (Object)this._bounds);
        }
        if (this._zoom != 13) {
            this.render(renderer, "zoom", new Integer(this.getZoom()));
        }
        if (this._large) {
            this.render(renderer, "showLargeCtrl", this.isShowLargeCtrl());
        }
        if (this._small) {
            this.render(renderer, "showSmallCtrl", this.isShowSmallCtrl());
        }
        if (!this._smallZoom) {
            renderer.render("showZoomCtrl", this.isShowZoomCtrl());
        }
        if (!this._type) {
            renderer.render("showTypeCtrl", this.isShowTypeCtrl());
        }
        if (!this._pan) {
            renderer.render("showPanCtrl", this.isShowPanCtrl());
        }
        if (this._scale) {
            renderer.render("showScaleCtrl", this.isShowScaleCtrl());
        }
        if (this._overview) {
            renderer.render("showOverviewCtrl", this.isShowOverviewCtrl());
        }
        if (!this._enableDragging) {
            renderer.render("enableDragging", this.isEnableDragging());
        }
        if (this._continuousZoom) {
            this.render(renderer, "continuousZoom", this.isContinuousZoom());
        }
        if (!this._doubleClickZoom) {
            renderer.render("doubleClickZoom", this.isDoubleClickZoom());
        }
        if (!this._scrollWheelZoom) {
            renderer.render("scrollWheelZoom", this.isScrollWheelZoom());
        }
        if (this._enableGoogleBar) {
            this.render(renderer, "enableGoogleBar", this.isEnableGoogleBar());
        }
        if (!"normal".equals(this._mapType)) {
            this.render(renderer, "mapType", this.getMapType());
        }
        if (this._satellite) {
            renderer.render("satellite", this.isSatellite());
        }
        if (!this._hybrid) {
            renderer.render("hybrid", this.isHybrid());
        }
        if (!this._physical) {
            renderer.render("physical", this.isPhysical());
        }
        if (!this._normal) {
            renderer.render("normal", this.isNormal());
        }
        if (this._sensor) {
            renderer.render("sensor", true);
        }
        if (!"3".equals(this._version)) {
            renderer.render("version", this._version);
        }
        if (!Strings.isBlank((String)this._baseDomain)) {
            renderer.render("baseDomain", this._baseDomain);
        }
        if (!Strings.isBlank((String)this._protocol)) {
            renderer.render("protocol", this._protocol);
        }
        if (!Strings.isBlank((String)this._language)) {
            renderer.render("language", this._language);
        }
        if (this._libraries != null) {
            renderer.render("libraries", this._libraries);
        }
        if (this._client != null) {
            renderer.render("client", this._client);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onMapMove")) {
            MapMoveEvent evt = MapMoveEvent.getMapMoveEvent(request);
            this.setCenterByClient(evt.getLatLng());
            this.setBoundsByClient(evt.getBounds());
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onMapZoom")) {
            MapZoomEvent evt = MapZoomEvent.getMapZoomEvent(request);
            int zoom = evt.getZoom();
            this.setZoomByClient(zoom);
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onInfoChange")) {
            InfoChangeEvent evt = InfoChangeEvent.getInfoChangeEvent(request);
            this.setInfoByClient(evt.getInfo());
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onMapClick") || cmd.equals("onMapDoubleClick") || cmd.equals("onMapRightClick")) {
            MapMouseEvent evt = MapMouseEvent.getMapMouseEvent(request);
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onSelect")) {
            SelectEvent evt = SelectEvent.getSelectEvent((AuRequest)request);
            Set selItems = evt.getSelectedItems();
            Component mitem = selItems == null || selItems.isEmpty() ? null : (Component)selItems.iterator().next();
            this.setSelectedItem(mitem);
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onMapTypeChange")) {
            MapTypeChangeEvent evt = MapTypeChangeEvent.getMapTypeChangeEvent(request);
            this.setMapTypeByClient(evt.getType());
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onMapDrop")) {
            MapDropEvent evt = MapDropEvent.getMapDropEvent(request);
            Component dragged = evt.getDragged();
            if (dragged instanceof Gmarker) {
                ((Gmarker)dragged).setAnchor(evt.getLatLng());
            }
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    static {
        Gmaps.addClientEvent((Class)Gmaps.class, (String)"onMapMove", (int)8192);
        Gmaps.addClientEvent((Class)Gmaps.class, (String)"onMapZoom", (int)8192);
        Gmaps.addClientEvent((Class)Gmaps.class, (String)"onInfoChange", (int)8195);
        Gmaps.addClientEvent((Class)Gmaps.class, (String)"onMapClick", (int)8192);
        Gmaps.addClientEvent((Class)Gmaps.class, (String)"onMapDoubleClick", (int)8192);
        Gmaps.addClientEvent((Class)Gmaps.class, (String)"onMapRightClick", (int)8192);
        Gmaps.addClientEvent((Class)Gmaps.class, (String)"onMapDrop", (int)8192);
        Gmaps.addClientEvent((Class)Gmaps.class, (String)"onMapTypeChange", (int)8192);
        Gmaps.addClientEvent((Class)Gmaps.class, (String)"onSelect", (int)8192);
    }

    private class UpdateBoundsListener
    implements EventListener,
    Express,
    Serializable {
        private static final long serialVersionUID = 200808261207L;

        private UpdateBoundsListener() {
        }

        public void onEvent(Event evt) {
            Gmaps.this.syncModel();
        }
    }
}

