/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.gmaps.LatLng;
import org.zkoss.gmaps.Mapitem;
import org.zkoss.gmaps.event.PathChangeEvent;
import org.zkoss.lang.Objects;
import org.zkoss.util.CollectionsX;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.XulElement;

public class Gpolyline
extends XulElement
implements Mapitem {
    private static final long serialVersionUID = 200807041530L;
    protected List _path = new LinkedList();
    private String _strpath;
    private String _color = "#808080";
    private int _weight = 5;
    private int _opacity = 50;
    private int _numLevels = 4;
    private int _zoomFactor = 32;
    protected String _encodedPolyline;
    private boolean _editable = false;

    public void addPoint(double lat, double lng, int level) {
        if (lat > 90.0 || lat < -90.0) {
            throw new IllegalArgumentException("latitude must be from -90 ~ +90: " + lat);
        }
        if (lng > 180.0 || lng < -180.0) {
            throw new IllegalArgumentException("longtitude must be from -180 ~ +180: " + lng);
        }
        this.addPath(new LatLng(lat, lng));
    }

    public void addPath(LatLng latLng) {
        this._path.add(latLng);
        this.clearCacheAndSmartUpdatePth();
    }

    public void setPoints(String points) {
        String[] arr = points.split(",");
        int length = arr.length;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; i += 3) {
            sb.append(arr[i]).append(",").append(arr[i + 1]);
            sb.append(",");
        }
        this.setPath(sb.toString());
    }

    public void setPath(String path) {
        if (!Objects.equals((Object)path, (Object)this._strpath)) {
            this._strpath = path;
            if (path != null) {
                this._path.clear();
                Collection list = CollectionsX.parse(null, (String)path, (char)',');
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    double lat = Double.parseDouble((String)it.next());
                    double lng = Double.parseDouble((String)it.next());
                    this._path.add(new LatLng(lat, lng));
                }
            }
            this.clearCacheAndSmartUpdatePth();
        }
    }

    public void setPath(List path) {
        if (!Objects.equals((Object)this._path, (Object)path)) {
            this._path = path;
            this.clearCacheAndSmartUpdatePth();
        }
    }

    public List getPath() {
        return this._path;
    }

    private void clearCacheAndSmartUpdatePth() {
        this._encodedPolyline = null;
        this.smartUpdate("path", this.getEncodedPolyline());
    }

    public String getEncodedPolyline() {
        if (this._encodedPolyline == null) {
            int lat = 0;
            int lng = 0;
            StringBuffer sb = new StringBuffer(this._path.size() * 4);
            Iterator it = this._path.iterator();
            while (it.hasNext()) {
                LatLng latLng = (LatLng)((Object)it.next());
                int tlat = this.e5(latLng.getLatitude());
                int tlng = this.e5(latLng.getLongitude());
                sb.append(Gpolyline.encodeLatLng(tlat - lat)).append(Gpolyline.encodeLatLng(tlng - lng));
                lat = tlat;
                lng = tlng;
            }
            this._encodedPolyline = sb.length() == 0 ? "??" : sb.toString();
        }
        return this._encodedPolyline;
    }

    protected int e5(double db) {
        return (int)Math.floor(db * 100000.0);
    }

    protected static String encodeLatLng(int e5) {
        boolean sign = e5 < 0;
        e5 <<= 1;
        if (sign) {
            e5 ^= 0xFFFFFFFF;
        }
        return Gpolyline.encodeInt(e5);
    }

    protected static String encodeInt(int x) {
        StringBuffer sb = new StringBuffer(6);
        do {
            int chunk = x & 0x1F;
            if ((x >>>= 5) != 0) {
                chunk |= 0x20;
            }
            sb.append((char)(chunk += 63));
        } while (x != 0);
        return sb.toString();
    }

    public void setEncodedPolylineByClient(String encodedPolyline) {
        if (!Objects.equals((Object)encodedPolyline, (Object)this._encodedPolyline)) {
            this._encodedPolyline = encodedPolyline;
            this.decodePolyline(this._encodedPolyline);
        }
    }

    protected void decodePolyline(String encodedPolyline) {
        Object[] values = Gpolyline.getDecodeLatLngs(encodedPolyline);
        int length = values.length;
        this._path.clear();
        if (length > 2) {
            this._path.add(new LatLng((Double)values[0], (Double)values[1]));
            for (int i = 2; i < length - 1; i += 2) {
                double preLat = ((LatLng)((Object)this._path.get(i / 2 - 1))).getLatitude();
                double preLng = ((LatLng)((Object)this._path.get(i / 2 - 1))).getLongitude();
                this._path.add(new LatLng((Double)values[i] + preLat, (Double)values[i + 1] + preLng));
            }
        }
    }

    protected static Object[] getDecodeLatLngs(String encodedPolyline) {
        int length = encodedPolyline.length();
        int index = 0;
        int value = 0;
        int shift = 0;
        LinkedList<Double> decodeLatLngs = new LinkedList<Double>();
        while (index < length) {
            int chunk = encodedPolyline.charAt(index++) - 63;
            value |= (chunk & 0x1F) << shift;
            shift += 5;
            if ((chunk & 0x20) != 0) continue;
            decodeLatLngs.add(Gpolyline.decodeInt(value));
            value = 0;
            shift = 0;
        }
        return decodeLatLngs.toArray();
    }

    protected static Double decodeInt(int x) {
        boolean sign = (x & 1) != 0;
        double value = sign ? (double)(~(x >> 1)) : (double)(x >> 1);
        return new Double(value / 100000.0);
    }

    public String getColor() {
        return this._color;
    }

    public void setColor(String color) {
        if (color == null) {
            color = "#808080";
        }
        if (!color.equals(this._color)) {
            this._color = color;
            this.smartRerender();
        }
    }

    public int getWeight() {
        return this._weight;
    }

    public void setWeight(int weight) {
        if (weight != this._weight) {
            this._weight = weight;
            this.smartRerender();
        }
    }

    public int getOpacity() {
        return this._opacity;
    }

    public void setOpacity(int opacity) {
        if (opacity < 0 || opacity > 100) {
            throw new UiException("Line opacity must be between 0 to 100 (inclusive): " + opacity);
        }
        if (opacity != this._opacity) {
            this._opacity = opacity;
            this.smartRerender();
        }
    }

    public int getNumLevels() {
        return this._numLevels;
    }

    public void setNumLevels(int numLevels) {
        if (numLevels < 1 || numLevels > 19) {
            throw new IllegalArgumentException("numLevels must be from 1 ~ 19: " + numLevels);
        }
        if (this._numLevels != numLevels) {
            this._numLevels = numLevels;
            int factor = 19 / numLevels;
            int mod = 19 % numLevels;
            this._zoomFactor = 2 << (mod > numLevels >> 1 ? factor + 1 : factor);
            this.smartRerender();
        }
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setEditable(boolean editable) {
        if (this._editable != editable) {
            this._editable = editable;
            this.smartUpdate("editable", this._editable);
        }
    }

    public int getZoomFactor() {
        return this._zoomFactor;
    }

    protected void prepareRerender(Map info) {
        info.put("path", this.getEncodedPolyline());
        info.put("color", this.getColor());
        info.put("weight", new Integer(this.getWeight()));
        info.put("opacity", new Double((double)this.getOpacity() / 100.0));
        info.put("editable", new Boolean(this.isEditable()));
    }

    protected void smartRerender() {
        HashMap info = new HashMap();
        this.prepareRerender(info);
        this.smartUpdate("rerender_", info);
    }

    public boolean isChildable() {
        return false;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "path", this.getEncodedPolyline());
        this.render(renderer, "color", this.getColor());
        this.render(renderer, "weight", new Integer(this.getWeight()));
        this.render(renderer, "opacity", new Double((double)this.getOpacity() / 100.0));
        this.render(renderer, "editable", this.isEditable());
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if ("onPathChange".equals(cmd)) {
            PathChangeEvent evt = PathChangeEvent.getPathChangeEvent(request);
            this.setEncodedPolylineByClient(evt.getPath());
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    static {
        Gpolyline.addClientEvent((Class)Gpolyline.class, (String)"onPathChange", (int)8193);
    }
}

