/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.compilecommand;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import net.nicoulaj.compilecommand.annotations.Break;
import net.nicoulaj.compilecommand.annotations.CompileOnly;
import net.nicoulaj.compilecommand.annotations.DontInline;
import net.nicoulaj.compilecommand.annotations.Exclude;
import net.nicoulaj.compilecommand.annotations.Inline;
import net.nicoulaj.compilecommand.annotations.Log;
import net.nicoulaj.compilecommand.annotations.Option;
import net.nicoulaj.compilecommand.annotations.Options;
import net.nicoulaj.compilecommand.annotations.Print;
import net.nicoulaj.compilecommand.annotations.Quiet;

public final class CompileCommandProcessor
extends AbstractProcessor {
    public static final String COMPILE_COMMAND_FILE_PATH_OPTION = "compile.command.file.output.path";
    public static final String COMPILE_COMMAND_FILE_PATH_DEFAULT = "META-INF/hotspot_compiler";
    private final SortedSet<String> lines = new TreeSet<String>();
    private boolean quiet = false;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(Break.class.getName(), CompileOnly.class.getName(), DontInline.class.getName(), Exclude.class.getName(), Inline.class.getName(), Log.class.getName(), Option.class.getName(), Options.class.getName(), Print.class.getName(), Quiet.class.getName()));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.info("Processing compiler hints annotations", new Object[0]);
        this.processBreak(roundEnv);
        this.processCompileOnly(roundEnv);
        this.processDontInline(roundEnv);
        this.processExclude(roundEnv);
        this.processInline(roundEnv);
        this.processLog(roundEnv);
        this.processOptions(roundEnv);
        this.processOption(roundEnv);
        this.processPrint(roundEnv);
        this.processQuiet(roundEnv);
        if (!roundEnv.processingOver()) {
            return true;
        }
        String outputPath = this.processingEnv.getOptions().get(COMPILE_COMMAND_FILE_PATH_OPTION);
        this.generateCompileCommandFile(outputPath != null ? outputPath : COMPILE_COMMAND_FILE_PATH_DEFAULT);
        this.info("Done processing compiler hints annotations", new Object[0]);
        return true;
    }

    private void processBreak(RoundEnvironment roundEnv) {
        this.processSimpleMethodAnnotation(Break.class, roundEnv);
    }

    private void processCompileOnly(RoundEnvironment roundEnv) {
        this.processSimpleMethodAnnotation(CompileOnly.class, roundEnv);
    }

    private void processDontInline(RoundEnvironment roundEnv) {
        this.processSimpleMethodAnnotation(DontInline.class, roundEnv);
    }

    private void processExclude(RoundEnvironment roundEnv) {
        this.processSimpleMethodAnnotation(Exclude.class, roundEnv);
    }

    private void processInline(RoundEnvironment roundEnv) {
        this.processSimpleMethodAnnotation(Inline.class, roundEnv);
    }

    private void processLog(RoundEnvironment roundEnv) {
        this.processSimpleMethodAnnotation(Log.class, roundEnv);
    }

    private void processOptions(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Options.class)) {
            for (String option : element.getAnnotation(Options.class).value()) {
                this.processOption(element, option, roundEnv);
            }
        }
    }

    private void processOption(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Option.class)) {
            this.processOption(element, element.getAnnotation(Option.class).value(), roundEnv);
        }
    }

    private void processOption(final Element element, String option, RoundEnvironment roundEnv) {
        this.lines.add(element.accept(new SimpleElementVisitor6<String, String>(){

            @Override
            public String visitExecutable(ExecutableElement e, String option) {
                return Option.class.getSimpleName().toLowerCase() + " " + CompileCommandProcessor.this.getDescriptor(e) + " " + option;
            }

            @Override
            protected String defaultAction(Element e, String option) {
                CompileCommandProcessor.this.error(element, "@%s is not allowed on a %s", new Object[]{Option.class.getSimpleName(), e.getKind()});
                return null;
            }
        }, option));
    }

    private void processPrint(RoundEnvironment roundEnv) {
        this.processSimpleMethodAnnotation(Print.class, roundEnv);
    }

    private void processQuiet(RoundEnvironment roundEnv) {
        if (!roundEnv.getElementsAnnotatedWith(Quiet.class).isEmpty()) {
            this.quiet = true;
        }
    }

    private void processSimpleMethodAnnotation(final Class<? extends Annotation> clazz, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(clazz)) {
            this.lines.add(element.accept(new SimpleElementVisitor6<String, RoundEnvironment>(){

                @Override
                public String visitExecutable(ExecutableElement e, RoundEnvironment roundEnvironment) {
                    return clazz.getSimpleName().toLowerCase() + " " + CompileCommandProcessor.this.getDescriptor(e);
                }

                @Override
                protected String defaultAction(Element e, RoundEnvironment roundEnvironment) {
                    CompileCommandProcessor.this.error(e, "@%s is not allowed on a %s", new Object[]{clazz.getSimpleName(), e.getKind()});
                    return null;
                }
            }, roundEnv));
        }
    }

    private String getDescriptor(ExecutableElement element) {
        return this.processingEnv.getElementUtils().getBinaryName((TypeElement)element.getEnclosingElement()) + "::" + element.getSimpleName() + " " + this.getSignature(element);
    }

    private String getSignature(ExecutableElement element) {
        Types types = this.processingEnv.getTypeUtils();
        StringBuilder sb = new StringBuilder("(");
        for (VariableElement variableElement : element.getParameters()) {
            sb.append(this.getSignature(types.erasure(variableElement.asType())));
        }
        return sb.append(")").append(this.getSignature(types.erasure(element.getReturnType()))).toString();
    }

    private String getSignature(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor6<String, Void>(){

            @Override
            public String visitPrimitive(PrimitiveType t, Void dummy) {
                String type = t.toString();
                if ("boolean".equals(type)) {
                    return "Z";
                }
                if ("short".equals(type)) {
                    return "S";
                }
                if ("int".equals(type)) {
                    return "I";
                }
                if ("long".equals(type)) {
                    return "J";
                }
                if ("float".equals(type)) {
                    return "F";
                }
                if ("double".equals(type)) {
                    return "D";
                }
                if ("char".equals(type)) {
                    return "C";
                }
                if ("byte".equals(type)) {
                    return "B";
                }
                return (String)super.visitPrimitive(t, dummy);
            }

            @Override
            public String visitNoType(NoType t, Void aVoid) {
                return "V";
            }

            @Override
            public String visitArray(ArrayType t, Void aVoid) {
                return "[" + CompileCommandProcessor.this.getSignature(t.getComponentType());
            }

            @Override
            protected String defaultAction(TypeMirror e, Void aVoid) {
                return "L" + e.toString() + ";";
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCompileCommandFile(String path) {
        this.info("Writing compiler command file at %s", path);
        PrintWriter pw = null;
        try {
            FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", path, new Element[0]);
            pw = new PrintWriter(new OutputStreamWriter(file.openOutputStream(), "UTF-8"));
            if (this.quiet) {
                pw.println("quiet");
            }
            for (String value : this.lines) {
                pw.println(value);
            }
            pw.flush();
        }
        catch (IOException e) {
            this.error("Failed writing compiler command file : %s", e);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    private void info(String msg, Object ... args) {
        this.message(Diagnostic.Kind.NOTE, msg, args);
    }

    private void info(Element element, String msg, Object ... args) {
        this.message(Diagnostic.Kind.NOTE, element, msg, args);
    }

    private void warn(String msg, Object ... args) {
        this.message(Diagnostic.Kind.WARNING, msg, args);
    }

    private void warn(Element element, String msg, Object ... args) {
        this.message(Diagnostic.Kind.WARNING, element, msg, args);
    }

    private void error(String msg, Object ... args) {
        this.message(Diagnostic.Kind.ERROR, msg, args);
    }

    private void error(Element element, String msg, Object ... args) {
        this.message(Diagnostic.Kind.ERROR, element, msg, args);
    }

    private void message(Diagnostic.Kind level, String msg, Object ... args) {
        this.processingEnv.getMessager().printMessage(level, String.format(msg, args));
    }

    private void message(Diagnostic.Kind level, Element element, String msg, Object ... args) {
        this.processingEnv.getMessager().printMessage(level, String.format(msg, args), element);
    }
}

