/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.license;

import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.rat.analysis.license.SimplePatternBasedLicense;
import org.apache.rat.api.MetaData;

public class CDDL1License
extends SimplePatternBasedLicense {
    public static final String LICENSE_LINE = "The contents of this file are subject to the terms of the Common Development[\\\\r\\\\n\\\\s]+and Distribution License(\"CDDL\") (the \"License\"). You may not use this file[\\\\r\\\\n\\\\s]+except in compliance with the License.";
    public static final String LICENSE_URL = ".*https://oss.oracle.com/licenses/CDDL.*";

    public CDDL1License() {
        super(MetaData.RAT_LICENSE_FAMILY_CATEGORY_DATUM_CDLL1, MetaData.RAT_LICENSE_FAMILY_NAME_DATUM_CDDL1, "", new String[]{LICENSE_LINE, LICENSE_URL});
    }

    private Pattern[] getRegExPatterns() {
        Pattern[] result;
        Object[] pttrns = this.getPatterns();
        if (ArrayUtils.isEmpty(pttrns)) {
            result = new Pattern[]{};
        } else {
            result = new Pattern[pttrns.length];
            for (int i = 0; i < pttrns.length; ++i) {
                result[i] = Pattern.compile((String)pttrns[i]);
            }
        }
        return result;
    }

    protected boolean matches(String pLine) {
        String[] pttrns;
        if (pLine != null && (pttrns = this.getPatterns()) != null) {
            for (Pattern pttrn : this.getRegExPatterns()) {
                if (!pttrn.matcher(pLine).find()) continue;
                return true;
            }
        }
        return false;
    }
}

