/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.AbstractApplication;
import org.jhotdraw.app.ApplicationModel;
import org.jhotdraw.app.Project;
import org.jhotdraw.app.action.AboutAction;
import org.jhotdraw.app.action.Actions;
import org.jhotdraw.app.action.ClearAction;
import org.jhotdraw.app.action.ClearRecentFilesAction;
import org.jhotdraw.app.action.CloseAction;
import org.jhotdraw.app.action.CopyAction;
import org.jhotdraw.app.action.CutAction;
import org.jhotdraw.app.action.DeleteAction;
import org.jhotdraw.app.action.DuplicateAction;
import org.jhotdraw.app.action.ExitAction;
import org.jhotdraw.app.action.LoadAction;
import org.jhotdraw.app.action.LoadRecentAction;
import org.jhotdraw.app.action.NewAction;
import org.jhotdraw.app.action.PasteAction;
import org.jhotdraw.app.action.RedoAction;
import org.jhotdraw.app.action.SaveAction;
import org.jhotdraw.app.action.SaveAsAction;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.app.action.ToggleVisibleAction;
import org.jhotdraw.app.action.UndoAction;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.ReversedList;
import org.jhotdraw.util.prefs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSDIApplication
extends AbstractApplication {
    private Project currentProject;
    private Preferences prefs;

    @Override
    public void launch(String[] args) {
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        super.launch(args);
    }

    @Override
    public void init() {
        super.init();
        this.prefs = Preferences.userNodeForPackage(this.getModel() == null ? this.getClass() : this.getModel().getClass());
        this.initLabels();
        this.initLookAndFeel();
        this.initApplicationActions();
    }

    @Override
    public void remove(Project p) {
        super.remove(p);
        if (this.projects().size() == 0) {
            this.stop();
        }
    }

    protected void initLookAndFeel() {
        System.setProperty("apple.laf.useScreenMenuBar", "false");
        System.setProperty("com.apple.macos.useScreenMenuBar", "false");
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        try {
            String lafName = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(lafName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (UIManager.getString("OptionPane.css") == null) {
            UIManager.put("OptionPane.css", "");
        }
    }

    protected void initApplicationActions() {
        ResourceBundleUtil appLabels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        ApplicationModel m = this.getModel();
        m.putAction("about", new AboutAction(this));
        m.putAction("exit", new ExitAction(this));
        m.putAction("clear", new ClearAction(this));
        m.putAction("new", new NewAction(this));
        appLabels.configureAction(m.getAction("new"), "newWindow");
        m.putAction("load", new LoadAction(this));
        m.putAction("clearRecentFiles", new ClearRecentFilesAction(this));
        m.putAction("save", new SaveAction(this));
        m.putAction("saveAs", new SaveAsAction(this));
        m.putAction("close", new CloseAction(this));
        m.putAction("undo", new UndoAction(this));
        m.putAction("redo", new RedoAction(this));
        m.putAction("cut", new CutAction());
        m.putAction("copy", new CopyAction());
        m.putAction("paste", new PasteAction());
        m.putAction("delete", new DeleteAction());
        m.putAction("duplicate", new DuplicateAction());
        m.putAction("selectAll", new SelectAllAction());
    }

    @Override
    protected void initProjectActions(Project p) {
    }

    @Override
    public void show(final Project p) {
        if (!p.isShowing()) {
            boolean moved;
            p.setShowing(true);
            File file = p.getFile();
            final JFrame f = new JFrame();
            String title = file == null ? this.labels.getString("unnamedFile") : file.getName();
            if (p.hasUnsavedChanges()) {
                title = title + "*";
            }
            f.setTitle(this.labels.getFormatted("frameTitle", title, this.getName(), p.getMultipleOpenId()));
            f.setDefaultCloseOperation(0);
            JPanel panel = (JPanel)this.wrapProjectComponent(p);
            f.add(panel);
            f.setMinimumSize(new Dimension(200, 200));
            f.setPreferredSize(new Dimension(600, 400));
            f.setJMenuBar(this.createMenuBar(p, (List)panel.getClientProperty("toolBarActions")));
            PreferencesUtil.installFramePrefsHandler(this.prefs, "project", f);
            Point loc = f.getLocation();
            block0: do {
                moved = false;
                for (Project aProject : this.projects()) {
                    if (aProject == p || SwingUtilities.getWindowAncestor(aProject.getComponent()) == null || !SwingUtilities.getWindowAncestor(aProject.getComponent()).getLocation().equals(loc)) continue;
                    loc.x += 22;
                    loc.y += 22;
                    moved = true;
                    continue block0;
                }
            } while (moved);
            f.setLocation(loc);
            f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    DefaultSDIApplication.this.setCurrentProject(p);
                    DefaultSDIApplication.this.getModel().getAction("close").actionPerformed(new ActionEvent(f, 1001, "windowClosing"));
                }

                public void windowActivated(WindowEvent e) {
                    DefaultSDIApplication.this.setCurrentProject(p);
                }
            });
            p.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    if (name.equals("hasUnsavedChanges") || name.equals("file") || name.equals("multipleOpenId")) {
                        File file = p.getFile();
                        String title = file == null ? DefaultSDIApplication.this.labels.getString("unnamedFile") : file.getName();
                        if (p.hasUnsavedChanges()) {
                            title = title + "*";
                        }
                        f.setTitle(DefaultSDIApplication.this.labels.getFormatted("frameTitle", title, DefaultSDIApplication.this.getName(), p.getMultipleOpenId()));
                    }
                }
            });
            f.setVisible(true);
        }
    }

    protected Component wrapProjectComponent(Project p) {
        JComponent c = p.getComponent();
        if (this.getModel() != null) {
            LinkedList<ToggleVisibleAction> toolBarActions = new LinkedList<ToggleVisibleAction>();
            int id = 0;
            for (JToolBar tb : new ReversedList<JToolBar>(this.getModel().createToolBars(this, p))) {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)tb, "North");
                panel.add((Component)c, "Center");
                c = panel;
                PreferencesUtil.installToolBarPrefsHandler(this.prefs, "toolbar." + ++id, tb);
                toolBarActions.addFirst(new ToggleVisibleAction(tb, tb.getName()));
            }
            JToolBar tb = new JToolBar();
            tb.setName(this.labels.getString("standardToolBarTitle"));
            this.addStandardActionsTo(tb, p);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)tb, "North");
            panel.add((Component)c, "Center");
            c = panel;
            PreferencesUtil.installToolBarPrefsHandler(this.prefs, "toolbar." + ++id, tb);
            toolBarActions.addFirst(new ToggleVisibleAction(tb, tb.getName()));
            panel.putClientProperty("toolBarActions", toolBarActions);
        }
        return c;
    }

    protected void addStandardActionsTo(JToolBar tb, Project p) {
        ApplicationModel m = this.getModel();
        JButton b = tb.add(m.getAction("clear"));
        b.setFocusable(false);
        b = tb.add(m.getAction("load"));
        b.setFocusable(false);
        b = tb.add(m.getAction("save"));
        tb.addSeparator();
        b = tb.add(m.getAction("undo"));
        b.setFocusable(false);
        b = tb.add(m.getAction("redo"));
        b.setFocusable(false);
        tb.addSeparator();
        b = tb.add(m.getAction("cut"));
        b.setFocusable(false);
        b = tb.add(m.getAction("copy"));
        b.setFocusable(false);
        b = tb.add(m.getAction("paste"));
        b.setFocusable(false);
    }

    @Override
    public void hide(Project p) {
        if (p.isShowing()) {
            p.setShowing(false);
            JFrame f = (JFrame)SwingUtilities.getWindowAncestor(p.getComponent());
            f.setVisible(false);
            f.remove(p.getComponent());
            f.dispose();
        }
    }

    @Override
    public void dispose(Project p) {
        super.dispose(p);
        if (this.projects().size() == 0) {
            this.stop();
        }
    }

    @Override
    public Project getCurrentProject() {
        return this.currentProject;
    }

    public void setCurrentProject(Project newValue) {
        Project oldValue = this.currentProject;
        this.currentProject = newValue;
        this.firePropertyChange("currentProject", oldValue, newValue);
    }

    protected JMenuBar createMenuBar(final Project p, List<Action> toolBarActions) {
        ApplicationModel model = this.getModel();
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        JMenuBar mb = new JMenuBar();
        JMenu m = new JMenu();
        labels.configureMenu(m, labels.getString("file"));
        m.add(model.getAction("clear"));
        m.add(model.getAction("new"));
        m.add(model.getAction("load"));
        final JMenu openRecentMenu = new JMenu();
        labels.configureMenu(openRecentMenu, "openRecent");
        openRecentMenu.add(model.getAction("clearRecentFiles"));
        this.updateOpenRecentMenu(openRecentMenu);
        m.add(openRecentMenu);
        m.addSeparator();
        m.add(model.getAction("save"));
        m.add(model.getAction("saveAs"));
        if (model.getAction("export") != null) {
            JMenuItem jMenuItem = m.add(model.getAction("export"));
        }
        m.addSeparator();
        m.add(model.getAction("exit"));
        mb.add(m);
        m = new JMenu();
        labels.configureMenu(m, labels.getString("edit"));
        m.add(model.getAction("undo"));
        m.add(model.getAction("redo"));
        m.addSeparator();
        m.add(model.getAction("cut"));
        m.add(model.getAction("copy"));
        m.add(model.getAction("paste"));
        m.add(model.getAction("duplicate"));
        m.add(model.getAction("delete"));
        m.addSeparator();
        m.add(model.getAction("selectAll"));
        mb.add(m);
        JMenu viewMenu = null;
        for (JMenu mm : model.createMenus(this, p)) {
            mb.add(mm);
            if (!mm.getText().equals(labels.getString("view"))) continue;
            viewMenu = mm;
        }
        if (toolBarActions != null && toolBarActions.size() > 0) {
            m = viewMenu != null ? viewMenu : new JMenu();
            JMenu m2 = toolBarActions.size() == 1 ? m : new JMenu(labels.getString("toolBars"));
            labels.configureMenu(m, labels.getString("view"));
            for (Action a : toolBarActions) {
                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(a);
                Actions.configureJCheckBoxMenuItem(cbmi, a);
                m2.add(cbmi);
            }
            if (m2 != m) {
                m.add(m2);
            }
            mb.add(m);
        }
        m = new JMenu();
        labels.configureMenu(m, labels.getString("help"));
        m.add(model.getAction("about"));
        mb.add(m);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name == "projectCount") {
                    if (p != null && !DefaultSDIApplication.this.projects().contains(p)) {
                        DefaultSDIApplication.this.removePropertyChangeListener(this);
                    }
                } else if (name == "recentFiles") {
                    DefaultSDIApplication.this.updateOpenRecentMenu(openRecentMenu);
                }
            }
        });
        return mb;
    }

    private void updateOpenRecentMenu(JMenu openRecentMenu) {
        if (openRecentMenu.getItemCount() > 0) {
            JMenuItem clearRecentFilesItem = openRecentMenu.getItem(openRecentMenu.getItemCount() - 1);
            openRecentMenu.removeAll();
            for (File f : this.recentFiles()) {
                openRecentMenu.add(new LoadRecentAction(this, f));
            }
            if (this.recentFiles().size() > 0) {
                openRecentMenu.addSeparator();
            }
            openRecentMenu.add(clearRecentFilesItem);
        }
    }

    @Override
    public boolean isSharingToolsAmongProjects() {
        return false;
    }

    @Override
    public Component getComponent() {
        Project p = this.getCurrentProject();
        return p == null ? null : p.getComponent();
    }
}

