/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.AbstractFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Layouter;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.util.ReversedList;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompositeFigure
extends AbstractFigure
implements CompositeFigure {
    private LinkedList<Figure> children = new LinkedList();
    private Rectangle2D.Double drawBounds;
    private Rectangle2D.Double bounds;
    private Layouter layouter;
    private ChildHandler childHandler = new ChildHandler(this);

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        if (detailLevel == 0) {
            return super.createHandles(0);
        }
        LinkedList<Handle> handles = new LinkedList<Handle>();
        return handles;
    }

    @Override
    public void add(Figure figure) {
        this.add(this.getChildCount(), figure);
    }

    @Override
    public void add(int index, Figure figure) {
        this.willChange();
        this.basicAdd(index, figure);
        if (this.getDrawing() != null) {
            figure.addNotify(this.getDrawing());
        }
        this.changed();
    }

    public void addAll(Collection<Figure> newFigures) {
        this.willChange();
        for (Figure f : newFigures) {
            this.basicAdd(this.getChildCount(), f);
            if (this.getDrawing() == null) continue;
            f.addNotify(this.getDrawing());
        }
        this.changed();
    }

    @Override
    public void basicAdd(Figure figure) {
        this.basicAdd(this.getChildCount(), figure);
    }

    @Override
    public void basicAdd(int index, Figure figure) {
        this.children.add(index, figure);
        figure.addFigureListener(this.childHandler);
        figure.addUndoableEditListener(this.childHandler);
    }

    public void basicAddAll(Collection<Figure> newFigures) {
        for (Figure f : newFigures) {
            this.basicAdd(this.getChildCount(), f);
        }
    }

    @Override
    public void addNotify(Drawing drawing) {
        super.addNotify(drawing);
        for (Figure child : this.children) {
            child.addNotify(drawing);
        }
    }

    @Override
    public void removeNotify(Drawing drawing) {
        for (Figure child : new LinkedList<Figure>(this.children)) {
            child.removeNotify(drawing);
        }
        super.removeNotify(drawing);
    }

    @Override
    public boolean remove(Figure figure) {
        int index = this.children.indexOf(figure);
        if (index == -1) {
            return false;
        }
        this.willChange();
        this.basicRemoveChild(index);
        if (this.getDrawing() != null) {
            figure.removeNotify(this.getDrawing());
        }
        this.changed();
        return true;
    }

    @Override
    public Figure removeChild(int index) {
        this.willChange();
        Figure removed = this.basicRemoveChild(index);
        if (this.getDrawing() != null) {
            removed.removeNotify(this.getDrawing());
        }
        this.changed();
        return removed;
    }

    @Override
    public boolean basicRemove(Figure figure) {
        int index = this.children.indexOf(figure);
        if (index == -1) {
            return false;
        }
        this.basicRemoveChild(index);
        return true;
    }

    @Override
    public Figure basicRemoveChild(int index) {
        Figure figure = this.children.remove(index);
        figure.removeFigureListener(this.childHandler);
        figure.removeUndoableEditListener(this.childHandler);
        return figure;
    }

    @Override
    public void removeAllChildren() {
        this.willChange();
        while (this.children.size() > 0) {
            Figure f = this.basicRemoveChild(this.children.size() - 1);
            if (this.getDrawing() == null) continue;
            f.addNotify(this.getDrawing());
        }
        this.changed();
    }

    @Override
    public void basicRemoveAllChildren() {
        while (this.children.size() > 0) {
            Figure figure = this.basicRemoveChild(this.children.size() - 1);
        }
    }

    public synchronized void sendToBack(Figure figure) {
        if (this.children.remove(figure)) {
            this.children.add(0, figure);
            figure.invalidate();
        }
    }

    public synchronized void sendToFront(Figure figure) {
        if (this.children.remove(figure)) {
            this.children.add(figure);
            figure.invalidate();
        }
    }

    @Override
    public void basicTransform(AffineTransform tx) {
        for (Figure f : this.children) {
            f.basicTransform(tx);
        }
        this.invalidateBounds();
    }

    @Override
    public void basicSetBounds(Point2D.Double anchor, Point2D.Double lead) {
        Rectangle2D.Double oldBounds = this.getBounds();
        Rectangle2D.Double newBounds = new Rectangle2D.Double(Math.min(anchor.x, lead.x), Math.min(anchor.y, lead.y), Math.abs(anchor.x - lead.x), Math.abs(anchor.y - lead.y));
        double sx = newBounds.width / oldBounds.width;
        double sy = newBounds.height / oldBounds.height;
        AffineTransform tx = new AffineTransform();
        tx.translate(-oldBounds.x, -oldBounds.y);
        if (!(Double.isNaN(sx) || Double.isNaN(sy) || sx == 1.0 && sy == 1.0 || sx < 1.0E-4 || sy < 1.0E-4)) {
            this.basicTransform(tx);
            tx.setToIdentity();
            tx.scale(sx, sy);
            this.basicTransform(tx);
            tx.setToIdentity();
        }
        tx.translate(newBounds.x, newBounds.y);
        this.basicTransform(tx);
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        this.fireUndoableEditHappened(e.getEdit());
    }

    @Override
    public List<Figure> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public Figure getChild(int index) {
        return this.children.get(index);
    }

    public List<Figure> getChildrenFrontToBack() {
        return this.children == null ? new LinkedList() : new ReversedList<Figure>(this.children);
    }

    @Override
    public void setAttribute(AttributeKey name, Object value) {
        this.willChange();
        for (Figure child : this.children) {
            child.setAttribute(name, value);
        }
        this.changed();
    }

    @Override
    public void basicSetAttribute(AttributeKey name, Object value) {
        for (Figure child : this.children) {
            child.basicSetAttribute(name, value);
        }
    }

    @Override
    public Object getAttribute(AttributeKey name) {
        return null;
    }

    @Override
    public boolean contains(Point2D.Double p) {
        if (this.getDrawBounds().contains(p)) {
            for (Figure child : this.getChildrenFrontToBack()) {
                if (!child.isVisible() || !child.contains(p)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Figure findFigureInside(Point2D.Double p) {
        if (this.getDrawBounds().contains(p)) {
            Figure found = null;
            for (Figure child : this.getChildrenFrontToBack()) {
                if (!child.isVisible() || (found = child.findFigureInside(p)) == null) continue;
                return found;
            }
        }
        return null;
    }

    public Figure findChild(Point2D.Double p) {
        if (this.getBounds().contains(p)) {
            Object found = null;
            for (Figure child : this.getChildrenFrontToBack()) {
                if (!child.isVisible() || !child.contains(p)) continue;
                return child;
            }
        }
        return null;
    }

    public int findChildIndex(Point2D.Double p) {
        Figure child = this.findChild(p);
        return child == null ? -1 : this.children.indexOf(child);
    }

    @Override
    public Layouter getLayouter() {
        return this.layouter;
    }

    @Override
    public void layout() {
        if (this.getLayouter() != null) {
            Rectangle2D.Double bounds = this.getBounds();
            Point2D.Double p = new Point2D.Double(bounds.x, bounds.y);
            Rectangle2D.Double r = this.getLayouter().layout(this, p, p);
            this.basicSetBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
            this.invalidateBounds();
        }
    }

    @Override
    public void setLayouter(Layouter newLayouter) {
        this.layouter = newLayouter;
    }

    @Override
    public Dimension2DDouble getPreferredSize() {
        if (this.layouter != null) {
            Rectangle2D.Double r = this.layouter.calculateLayout(this, this.getStartPoint(), this.getEndPoint());
            return new Dimension2DDouble(r.width, r.height);
        }
        return super.getPreferredSize();
    }

    @Override
    public Rectangle2D.Double getFigureDrawBounds() {
        if (this.drawBounds == null) {
            for (Figure child : this.getChildrenFrontToBack()) {
                Rectangle2D.Double childBounds;
                if (!child.isVisible() || (childBounds = child.getDrawBounds()).isEmpty()) continue;
                if (this.drawBounds == null) {
                    this.drawBounds = childBounds;
                    continue;
                }
                this.drawBounds.add(childBounds);
            }
        }
        return this.drawBounds == null ? new Rectangle2D.Double(0.0, 0.0, -1.0, -1.0) : (Rectangle2D.Double)this.drawBounds.clone();
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.bounds == null) {
            for (Figure child : this.getChildrenFrontToBack()) {
                if (!child.isVisible()) continue;
                if (this.bounds == null) {
                    this.bounds = child.getBounds();
                    continue;
                }
                this.bounds.add(child.getBounds());
            }
        }
        return this.bounds == null ? new Rectangle2D.Double(0.0, 0.0, -1.0, -1.0) : (Rectangle2D.Double)this.bounds.clone();
    }

    @Override
    public void drawFigure(Graphics2D g) {
        for (Figure child : this.children) {
            if (!child.isVisible()) continue;
            child.draw(g);
        }
        if (this.isConnectorsVisible()) {
            this.drawConnectors(g);
        }
    }

    protected void drawConnectors(Graphics2D g) {
    }

    @Override
    public AbstractCompositeFigure clone() {
        AbstractCompositeFigure that = (AbstractCompositeFigure)super.clone();
        that.childHandler = new ChildHandler(that);
        that.children = new LinkedList();
        for (Figure thisChild : this.children) {
            Figure thatChild = (Figure)thisChild.clone();
            that.children.add(thatChild);
            thatChild.addFigureListener(that.childHandler);
            thatChild.addUndoableEditListener(that.childHandler);
        }
        return that;
    }

    protected void invalidateBounds() {
        this.bounds = null;
        this.drawBounds = null;
    }

    @Override
    public Collection<Figure> getDecomposition() {
        LinkedList<Figure> list = new LinkedList<Figure>();
        list.add(this);
        list.addAll(this.getChildren());
        return list;
    }

    @Override
    public void read(DOMInput in) throws IOException {
        in.openElement("children");
        for (int i = 0; i < in.getElementCount(); ++i) {
            this.add((Figure)in.readObject(i));
        }
        in.closeElement();
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        out.openElement("children");
        for (Figure child : this.getChildren()) {
            out.writeObject(child);
        }
        out.closeElement();
    }

    @Override
    public Map<AttributeKey, Object> getAttributes() {
        return new HashMap<AttributeKey, Object>();
    }

    @Override
    public void restoreTo(Object geometry) {
        LinkedList list = (LinkedList)geometry;
        int index = 0;
        for (Object geom : list) {
            this.getChild(index).restoreTo(geom);
            ++index;
        }
        this.invalidateBounds();
    }

    @Override
    public Object getRestoreData() {
        LinkedList<Object> list = new LinkedList<Object>();
        for (Figure child : this.children) {
            list.add(child.getRestoreData());
        }
        return list;
    }

    @Override
    public void willChange() {
        super.willChange();
        if (this.getChangingDepth() == 1) {
            for (Figure child : this.children) {
                child.willChange();
            }
        }
    }

    @Override
    public void changed() {
        if (this.getChangingDepth() == 1) {
            for (Figure child : this.children) {
                child.changed();
            }
        }
        super.changed();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.invalidateBounds();
    }

    @Override
    protected void validate() {
        super.validate();
        this.layout();
        this.invalidateBounds();
    }

    public void removeAttribute(AttributeKey key) {
    }

    public boolean hasAttribute(AttributeKey key) {
        return false;
    }

    private static class ChildHandler
    implements FigureListener,
    UndoableEditListener {
        private AbstractCompositeFigure owner;

        private ChildHandler(AbstractCompositeFigure owner) {
            this.owner = owner;
        }

        public void figureRequestRemove(FigureEvent e) {
            this.owner.remove(e.getFigure());
        }

        public void figureRemoved(FigureEvent evt) {
        }

        public void figureChanged(FigureEvent e) {
            if (!this.owner.isChanging()) {
                this.owner.willChange();
                this.owner.fireFigureChanged(e);
                this.owner.changed();
            }
        }

        public void figureAdded(FigureEvent e) {
        }

        public void figureAttributeChanged(FigureEvent e) {
        }

        public void figureAreaInvalidated(FigureEvent e) {
            if (!this.owner.isChanging()) {
                this.owner.fireAreaInvalidated(e.getInvalidatedArea());
            }
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            this.owner.fireUndoableEditHappened(e.getEdit());
        }
    }
}

