/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.AbstractCompositeFigure;
import org.jhotdraw.draw.AttributeChangeEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.MoveHandle;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicalCompositeFigure
extends AbstractCompositeFigure {
    protected HashMap<AttributeKey, Object> attributes = new HashMap();
    private HashSet<AttributeKey> forbiddenAttributes;
    private Figure presentationFigure;
    private PresentationFigureHandler presentationFigureHandler = new PresentationFigureHandler(this);

    public GraphicalCompositeFigure() {
        this(null);
    }

    public GraphicalCompositeFigure(Figure newPresentationFigure) {
        this.setPresentationFigure(newPresentationFigure);
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.getPresentationFigure() == null) {
            return super.getBounds();
        }
        return this.getPresentationFigure().getBounds();
    }

    @Override
    public boolean contains(Point2D.Double p) {
        if (this.getPresentationFigure() != null) {
            return this.getPresentationFigure().contains(p);
        }
        return super.contains(p);
    }

    @Override
    public void addNotify(Drawing drawing) {
        super.addNotify(drawing);
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().addNotify(drawing);
        }
    }

    @Override
    public void removeNotify(Drawing drawing) {
        super.removeNotify(drawing);
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().removeNotify(drawing);
        }
    }

    @Override
    public Rectangle2D.Double getFigureDrawBounds() {
        Rectangle2D.Double r;
        if (this.getPresentationFigure() != null) {
            Rectangle2D.Double presentationBounds = this.getPresentationFigure().getDrawBounds();
            r = super.getFigureDrawBounds();
            if (r.isEmpty()) {
                r = presentationBounds;
            } else {
                r.add(presentationBounds);
            }
        } else {
            r = super.getFigureDrawBounds();
        }
        return r;
    }

    @Override
    public void basicSetBounds(Point2D.Double anchor, Point2D.Double lead) {
        if (this.getLayouter() == null) {
            super.basicSetBounds(anchor, lead);
            this.basicSetPresentationFigureBounds(anchor, lead);
        } else {
            Rectangle2D.Double r = this.getLayouter().layout(this, anchor, lead);
            this.basicSetPresentationFigureBounds(new Point2D.Double(r.getX(), r.getY()), new Point2D.Double(Math.max(lead.x, (double)((int)r.getMaxX())), Math.max(lead.y, (double)((int)r.getMaxY()))));
            this.invalidate();
        }
    }

    protected void superBasicSetBounds(Point2D.Double anchor, Point2D.Double lead) {
        super.basicSetBounds(anchor, lead);
    }

    protected void basicSetPresentationFigureBounds(Point2D.Double anchor, Point2D.Double lead) {
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().basicSetBounds(anchor, lead);
        }
    }

    @Override
    public void basicTransform(AffineTransform tx) {
        super.basicTransform(tx);
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().basicTransform(tx);
        }
    }

    @Override
    public void drawFigure(Graphics2D g) {
        this.drawPresentationFigure(g);
        super.drawFigure(g);
    }

    protected void drawPresentationFigure(Graphics2D g) {
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().draw(g);
        }
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
            MoveHandle.addMoveHandles(this, handles);
        }
        return handles;
    }

    public void setPresentationFigure(Figure newPresentationFigure) {
        if (this.presentationFigure != null) {
            this.presentationFigure.removeFigureListener(this.presentationFigureHandler);
            this.presentationFigure.removeUndoableEditListener(this.presentationFigureHandler);
            if (this.getDrawing() != null) {
                this.presentationFigure.removeNotify(this.getDrawing());
            }
        }
        this.presentationFigure = newPresentationFigure;
        if (this.presentationFigure != null) {
            this.presentationFigure.addFigureListener(this.presentationFigureHandler);
            this.presentationFigure.addUndoableEditListener(this.presentationFigureHandler);
            if (this.getDrawing() != null) {
                this.presentationFigure.addNotify(this.getDrawing());
            }
        }
    }

    public Figure getPresentationFigure() {
        return this.presentationFigure;
    }

    @Override
    public GraphicalCompositeFigure clone() {
        GraphicalCompositeFigure that = (GraphicalCompositeFigure)super.clone();
        Figure figure = that.presentationFigure = this.presentationFigure == null ? null : (Figure)this.presentationFigure.clone();
        if (that.presentationFigure != null) {
            that.presentationFigure.addFigureListener(that.presentationFigureHandler);
            that.presentationFigure.addUndoableEditListener(that.presentationFigureHandler);
        }
        return that;
    }

    @Override
    public void remap(HashMap<Figure, Figure> oldToNew) {
        super.remap(oldToNew);
        if (this.presentationFigure != null) {
            this.presentationFigure.remap(oldToNew);
        }
    }

    @Override
    public void setAttribute(AttributeKey key, Object newValue) {
        if (this.forbiddenAttributes == null || !this.forbiddenAttributes.contains(key)) {
            this.willChange();
            if (this.getPresentationFigure() != null) {
                this.getPresentationFigure().setAttribute(key, newValue);
            }
            super.setAttribute(key, newValue);
            Object oldValue = this.attributes.put(key, newValue);
            this.fireAttributeChanged(key, oldValue, newValue);
            this.fireUndoableEditHappened(new AttributeChangeEdit(this, key, oldValue, newValue));
            this.changed();
        }
    }

    @Override
    public void basicSetAttribute(AttributeKey key, Object newValue) {
        if (this.forbiddenAttributes == null || !this.forbiddenAttributes.contains(key)) {
            if (this.getPresentationFigure() != null) {
                this.getPresentationFigure().basicSetAttribute(key, newValue);
            }
            super.basicSetAttribute(key, newValue);
            Object object = this.attributes.put(key, newValue);
        }
    }

    public void setAttributeEnabled(AttributeKey key, boolean b) {
        if (this.forbiddenAttributes == null) {
            this.forbiddenAttributes = new HashSet();
        }
        if (b) {
            this.forbiddenAttributes.remove(key);
        } else {
            this.forbiddenAttributes.add(key);
        }
    }

    @Override
    public Object getAttribute(AttributeKey key) {
        if (this.getPresentationFigure() != null) {
            return this.getPresentationFigure().getAttribute(key);
        }
        return !this.attributes.containsKey(key) ? key.getDefaultValue() : this.attributes.get(key);
    }

    protected void applyAttributesTo(Figure that) {
        for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
            that.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    protected void writeAttributes(DOMOutput out) throws IOException {
        Figure prototype = (Figure)out.getPrototype();
        boolean isElementOpen = false;
        for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
            Object attributeValue;
            Object prototypeValue;
            AttributeKey key = entry.getKey();
            if (this.forbiddenAttributes != null && this.forbiddenAttributes.contains(key) || (prototypeValue = key.get(prototype)) == (attributeValue = key.get(this)) && (prototypeValue == null || attributeValue == null || prototypeValue.equals(attributeValue))) continue;
            if (!isElementOpen) {
                out.openElement("a");
                isElementOpen = true;
            }
            out.openElement(key.getKey());
            out.writeObject(entry.getValue());
            out.closeElement();
        }
        if (isElementOpen) {
            out.closeElement();
        }
    }

    protected void readAttributes(DOMInput in) throws IOException {
        if (in.getElementCount("a") > 0) {
            in.openElement("a");
            for (int i = in.getElementCount() - 1; i >= 0; --i) {
                in.openElement(i);
                String name = in.getTagName();
                Object value = in.readObject();
                AttributeKey key = this.getAttributeKey(name);
                if (key != null && key.isAssignable(value) && (this.forbiddenAttributes == null || !this.forbiddenAttributes.contains(key))) {
                    this.setAttribute(key, value);
                }
                in.closeElement();
            }
            in.closeElement();
        }
    }

    protected AttributeKey getAttributeKey(String name) {
        return AttributeKeys.supportedAttributeMap.get(name);
    }

    @Override
    public Map<AttributeKey, Object> getAttributes() {
        return new HashMap<AttributeKey, Object>(this.attributes);
    }

    public Point2D.Double chop(Point2D.Double from) {
        Rectangle2D.Double r = this.getBounds();
        if (AttributeKeys.STROKE_COLOR.get(this) != null) {
            double grow;
            switch (AttributeKeys.STROKE_PLACEMENT.get(this)) {
                default: {
                    grow = AttributeKeys.getStrokeTotalWidth(this);
                    break;
                }
                case OUTSIDE: {
                    grow = AttributeKeys.getStrokeTotalWidth(this);
                    break;
                }
                case INSIDE: {
                    grow = 0.0;
                }
            }
            Geom.grow(r, grow, grow);
        }
        return Geom.angleToPoint(r, Geom.pointToAngle(r, from));
    }

    private static class PresentationFigureHandler
    implements FigureListener,
    UndoableEditListener {
        private GraphicalCompositeFigure owner;

        private PresentationFigureHandler(GraphicalCompositeFigure owner) {
            this.owner = owner;
        }

        public void figureRequestRemove(FigureEvent e) {
            this.owner.remove(e.getFigure());
        }

        public void figureRemoved(FigureEvent evt) {
        }

        public void figureChanged(FigureEvent e) {
            if (!this.owner.isChanging()) {
                this.owner.willChange();
                this.owner.fireFigureChanged(e);
                this.owner.changed();
            }
        }

        public void figureAdded(FigureEvent e) {
        }

        public void figureAttributeChanged(FigureEvent e) {
        }

        public void figureAreaInvalidated(FigureEvent e) {
            if (!this.owner.isChanging()) {
                this.owner.fireAreaInvalidated(e.getInvalidatedArea());
            }
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            this.owner.fireUndoableEditHappened(e.getEdit());
        }
    }
}

