/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Map;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FloatingTextField;
import org.jhotdraw.draw.TextHolder;

public class TextTool
extends CreationTool
implements ActionListener {
    private FloatingTextField textField;
    private TextHolder typingTarget;

    public TextTool(TextHolder prototype) {
        super(prototype);
    }

    public TextTool(Figure prototype, Map attributes) {
        super(prototype, (Map<AttributeKey, Object>)attributes);
    }

    public void deactivate(DrawingEditor editor) {
        this.endEdit();
        super.deactivate(editor);
    }

    public void mousePressed(MouseEvent e) {
        TextHolder textHolder = null;
        Figure pressedFigure = this.getDrawing().findFigureInside(this.getView().viewToDrawing(new Point(e.getX(), e.getY())));
        if (pressedFigure instanceof TextHolder && !(textHolder = ((TextHolder)pressedFigure).getLabelFor()).isEditable()) {
            textHolder = null;
        }
        if (textHolder != null) {
            this.beginEdit(textHolder);
            return;
        }
        if (this.typingTarget != null) {
            this.endEdit();
            this.fireToolDone();
        } else {
            super.mousePressed(e);
            textHolder = (TextHolder)this.getCreatedFigure();
            this.beginEdit(textHolder);
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    protected void beginEdit(TextHolder textHolder) {
        if (this.textField == null) {
            this.textField = new FloatingTextField();
            this.textField.addActionListener(this);
        }
        if (textHolder != this.typingTarget && this.typingTarget != null) {
            this.endEdit();
        }
        this.textField.createOverlay(this.getView(), textHolder);
        this.textField.setBounds(this.getFieldBounds(textHolder), textHolder.getText());
        this.textField.requestFocus();
        this.typingTarget = textHolder;
    }

    private Rectangle getFieldBounds(TextHolder figure) {
        Rectangle box = this.getView().drawingToView(figure.getBounds());
        Insets insets = this.textField.getInsets();
        return new Rectangle(box.x - insets.left, box.y - insets.top, box.width + insets.left + insets.right, box.height + insets.top + insets.bottom);
    }

    public void mouseReleased(MouseEvent evt) {
    }

    protected void endEdit() {
        if (this.typingTarget != null) {
            if (this.textField.getText().length() > 0) {
                this.typingTarget.setText(this.textField.getText());
                if (this.createdFigure != null) {
                    this.getDrawing().fireUndoableEditHappened(this.creationEdit);
                    this.createdFigure = null;
                }
            } else if (this.createdFigure != null) {
                this.getDrawing().remove(this.getAddedFigure());
            } else {
                this.typingTarget.setText("");
            }
            this.typingTarget = null;
            this.textField.endOverlay();
        }
    }

    public void actionPerformed(ActionEvent event) {
        this.endEdit();
        this.fireToolDone();
    }
}

