/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractLayouter;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Insets2DDouble;

public class VerticalLayouter
extends AbstractLayouter {
    public Rectangle2D.Double calculateLayout(CompositeFigure layoutable, Point2D.Double anchor, Point2D.Double lead) {
        Insets2DDouble layoutInsets = AttributeKeys.LAYOUT_INSETS.get(layoutable);
        if (layoutInsets == null) {
            layoutInsets = new Insets2DDouble(0.0, 0.0, 0.0, 0.0);
        }
        Rectangle2D.Double layoutBounds = new Rectangle2D.Double(anchor.x, anchor.y, 0.0, 0.0);
        for (Figure child : layoutable.getChildren()) {
            if (!child.isVisible()) continue;
            Dimension2DDouble preferredSize = child.getPreferredSize();
            Insets2DDouble ins = this.getInsets(child);
            layoutBounds.width = Math.max(layoutBounds.width, preferredSize.width + ins.left + ins.right);
            layoutBounds.height += preferredSize.height + ins.top + ins.bottom;
        }
        layoutBounds.width += layoutInsets.left + layoutInsets.right;
        layoutBounds.height += layoutInsets.top + layoutInsets.bottom;
        return layoutBounds;
    }

    public Rectangle2D.Double layout(CompositeFigure layoutable, Point2D.Double anchor, Point2D.Double lead) {
        Insets2DDouble layoutInsets = AttributeKeys.LAYOUT_INSETS.get(layoutable);
        if (layoutInsets == null) {
            layoutInsets = new Insets2DDouble(0.0, 0.0, 0.0, 0.0);
        }
        Rectangle2D.Double layoutBounds = this.calculateLayout(layoutable, anchor, lead);
        double y = layoutBounds.y + layoutInsets.top;
        for (Figure child : layoutable.getChildren()) {
            if (!child.isVisible()) continue;
            Insets2DDouble insets = this.getInsets(child);
            double height = child.getPreferredSize().height;
            child.basicSetBounds(new Point2D.Double(layoutBounds.x + layoutInsets.left + insets.left, y + insets.top), new Point2D.Double(layoutBounds.x + layoutBounds.width - layoutInsets.right - insets.right, y + insets.top + height));
            y += height + insets.top + insets.bottom;
        }
        return layoutBounds;
    }
}

