/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Locale;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.util.ResourceBundleUtil;

public class ApplyAttributesAction
extends AbstractSelectedAction {
    private ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels", Locale.getDefault());

    public ApplyAttributesAction(DrawingEditor editor) {
        super(editor);
        this.labels.configureAction(this, "attributesApply");
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        this.applyAttributes();
    }

    public void applyAttributes() {
        DrawingEditor editor = this.getEditor();
        for (Figure figure : this.getView().getSelectedFigures()) {
            editor.applyDefaultAttributesTo(figure);
        }
    }

    public void selectionChanged(FigureSelectionEvent evt) {
        this.setEnabled(this.getView().getSelectionCount() == 1);
    }
}

